<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Accountmap $accountmap
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Accountmap'), ['action' => 'edit', $accountmap->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Accountmap'), ['action' => 'delete', $accountmap->id], ['confirm' => __('Are you sure you want to delete # {0}?', $accountmap->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Accountmaps'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Accountmap'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="accountmaps view content">
            <h3><?= h($accountmap->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('OldAccountCode') ?></th>
                    <td><?= h($accountmap->OldAccountCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('NewAccountCode') ?></th>
                    <td><?= h($accountmap->NewAccountCode) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($accountmap->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
