<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Appsetting> $appsettings
 */
?>
<div class="appsettings index content">
    <?= $this->Html->link(__('New Appsetting'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Appsettings') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('AppSettingID') ?></th>
                    <th><?= $this->Paginator->sort('Value') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($appsettings as $appsetting): ?>
                <tr>
                    <td><?= $this->Number->format($appsetting->id) ?></td>
                    <td><?= h($appsetting->AppSettingID) ?></td>
                    <td><?= h($appsetting->Value) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $appsetting->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $appsetting->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $appsetting->id], ['confirm' => __('Are you sure you want to delete # {0}?', $appsetting->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
