<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Loanmaster $loanmaster
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $loanmaster->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $loanmaster->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Loanmasters'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="loanmasters form content">
            <?= $this->Form->create($loanmaster) ?>
            <fieldset>
                <legend><?= __('Edit Loanmaster') ?></legend>
                <?php
                    echo $this->Form->control('MemberId');
                    echo $this->Form->control('LoanType');
                    echo $this->Form->control('ApprovedLoanAmount');
                    echo $this->Form->control('MonthsToPay');
                    echo $this->Form->control('ServiceFee');
                    echo $this->Form->control('PercentInterest');
                    echo $this->Form->control('Penalty');
                    echo $this->Form->control('NetAmountOfLoan');
                    echo $this->Form->control('Insurance');
                    echo $this->Form->control('PercentCapitalBuildUp');
                    echo $this->Form->control('PrePayments');
                    echo $this->Form->control('OtherDeductions');
                    echo $this->Form->control('MonthlyAmortization');
                    echo $this->Form->control('AmortizationStart');
                    echo $this->Form->control('AmortizationEnd');
                    echo $this->Form->control('OtherPayments');
                    echo $this->Form->control('LessRebates');
                    echo $this->Form->control('ApprovedDate');
                    echo $this->Form->control('Status');
                    echo $this->Form->control('EntryDate');
                    echo $this->Form->control('UpdateDateTime');
                    echo $this->Form->control('OtherDeductionsPrePayment');
                    echo $this->Form->control('OtherDeductionsCanteen');
                    echo $this->Form->control('Remarks');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
