<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Membercapitalbuildup> $membercapitalbuildups
 */
?>
<div class="membercapitalbuildups index content">
    <?= $this->Html->link(__('New Membercapitalbuildup'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Membercapitalbuildups') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('member_id') ?></th>
                    <th><?= $this->Paginator->sort('MonthlyCbu') ?></th>
                    <th><?= $this->Paginator->sort('DatePaid') ?></th>
                    <th><?= $this->Paginator->sort('Remarks') ?></th>
                    <th><?= $this->Paginator->sort('IsDeduction') ?></th>
                    <th><?= $this->Paginator->sort('EntryDate') ?></th>
                    <th><?= $this->Paginator->sort('UpdateDateTime') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($membercapitalbuildups as $membercapitalbuildup): ?>
                <tr>
                    <td><?= $this->Number->format($membercapitalbuildup->id) ?></td>
                    <td><?= $membercapitalbuildup->has('member') ? $this->Html->link($membercapitalbuildup->member->id, ['controller' => 'Members', 'action' => 'view', $membercapitalbuildup->member->id]) : '' ?></td>
                    <td><?= $membercapitalbuildup->MonthlyCbu === null ? '' : $this->Number->format($membercapitalbuildup->MonthlyCbu) ?></td>
                    <td><?= h($membercapitalbuildup->DatePaid) ?></td>
                    <td><?= h($membercapitalbuildup->Remarks) ?></td>
                    <td><?= h($membercapitalbuildup->IsDeduction) ?></td>
                    <td><?= h($membercapitalbuildup->EntryDate) ?></td>
                    <td><?= h($membercapitalbuildup->UpdateDateTime) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $membercapitalbuildup->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $membercapitalbuildup->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $membercapitalbuildup->id], ['confirm' => __('Are you sure you want to delete # {0}?', $membercapitalbuildup->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
