<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Memberschildren> $memberschildrens
 */
?>
<div class="memberschildrens index content">
    <?= $this->Html->link(__('New Memberschildren'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Memberschildrens') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('member_id') ?></th>
                    <th><?= $this->Paginator->sort('ChildName') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($memberschildrens as $memberschildren): ?>
                <tr>
                    <td><?= $this->Number->format($memberschildren->id) ?></td>
                    <td><?= $memberschildren->has('member') ? $this->Html->link($memberschildren->member->id, ['controller' => 'Members', 'action' => 'view', $memberschildren->member->id]) : '' ?></td>
                    <td><?= h($memberschildren->ChildName) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $memberschildren->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $memberschildren->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $memberschildren->id], ['confirm' => __('Are you sure you want to delete # {0}?', $memberschildren->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
