<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Systemcounter> $systemcounters
 */
?>
<div class="systemcounters index content">
    <?= $this->Html->link(__('New Systemcounter'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Systemcounters') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('TransactionCode') ?></th>
                    <th><?= $this->Paginator->sort('TransactionNumber') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($systemcounters as $systemcounter): ?>
                <tr>
                    <td><?= $this->Number->format($systemcounter->id) ?></td>
                    <td><?= h($systemcounter->TransactionCode) ?></td>
                    <td><?= $systemcounter->TransactionNumber === null ? '' : $this->Number->format($systemcounter->TransactionNumber) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $systemcounter->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $systemcounter->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $systemcounter->id], ['confirm' => __('Are you sure you want to delete # {0}?', $systemcounter->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
