<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Transactiondetail> $transactiondetails
 */
?>
<div class="transactiondetails index content">
    <?= $this->Html->link(__('New Transactiondetail'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Transactiondetails') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('TransactionNumber') ?></th>
                    <th><?= $this->Paginator->sort('TransactionCode') ?></th>
                    <th><?= $this->Paginator->sort('TransactionDate') ?></th>
                    <th><?= $this->Paginator->sort('AccountCode') ?></th>
                    <th><?= $this->Paginator->sort('Debit') ?></th>
                    <th><?= $this->Paginator->sort('Credit') ?></th>
                    <th><?= $this->Paginator->sort('Sequence') ?></th>
                    <th><?= $this->Paginator->sort('EntryDate') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactiondetails as $transactiondetail): ?>
                <tr>
                    <td><?= $this->Number->format($transactiondetail->id) ?></td>
                    <td><?= $transactiondetail->TransactionNumber === null ? '' : $this->Number->format($transactiondetail->TransactionNumber) ?></td>
                    <td><?= h($transactiondetail->TransactionCode) ?></td>
                    <td><?= h($transactiondetail->TransactionDate) ?></td>
                    <td><?= h($transactiondetail->AccountCode) ?></td>
                    <td><?= $transactiondetail->Debit === null ? '' : $this->Number->format($transactiondetail->Debit) ?></td>
                    <td><?= $transactiondetail->Credit === null ? '' : $this->Number->format($transactiondetail->Credit) ?></td>
                    <td><?= $transactiondetail->Sequence === null ? '' : $this->Number->format($transactiondetail->Sequence) ?></td>
                    <td><?= h($transactiondetail->EntryDate) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $transactiondetail->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $transactiondetail->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $transactiondetail->id], ['confirm' => __('Are you sure you want to delete # {0}?', $transactiondetail->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
