<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Transactionlog> $transactionlogs
 */
?>
<div class="transactionlogs index content">
    <?= $this->Html->link(__('New Transactionlog'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Transactionlogs') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('RowId') ?></th>
                    <th><?= $this->Paginator->sort('TransactionDate') ?></th>
                    <th><?= $this->Paginator->sort('UserId') ?></th>
                    <th><?= $this->Paginator->sort('TableName') ?></th>
                    <th><?= $this->Paginator->sort('TransName') ?></th>
                    <th><?= $this->Paginator->sort('DeviceName') ?></th>
                    <th><?= $this->Paginator->sort('Reference1') ?></th>
                    <th><?= $this->Paginator->sort('Reference2') ?></th>
                    <th><?= $this->Paginator->sort('Reference3') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactionlogs as $transactionlog): ?>
                <tr>
                    <td><?= $this->Number->format($transactionlog->id) ?></td>
                    <td><?= h($transactionlog->RowId) ?></td>
                    <td><?= h($transactionlog->TransactionDate) ?></td>
                    <td><?= h($transactionlog->UserId) ?></td>
                    <td><?= h($transactionlog->TableName) ?></td>
                    <td><?= h($transactionlog->TransName) ?></td>
                    <td><?= h($transactionlog->DeviceName) ?></td>
                    <td><?= h($transactionlog->Reference1) ?></td>
                    <td><?= h($transactionlog->Reference2) ?></td>
                    <td><?= h($transactionlog->Reference3) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $transactionlog->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $transactionlog->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $transactionlog->id], ['confirm' => __('Are you sure you want to delete # {0}?', $transactionlog->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
