<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Uam> $uams
 */
?>
<div class="uams index content">
    <?= $this->Html->link(__('New Uam'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Uams') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('group_id') ?></th>
                    <th><?= $this->Paginator->sort('controller') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($uams as $uam): ?>
                <tr>
                    <td><?= $this->Number->format($uam->id) ?></td>
                    <td><?= $uam->has('group') ? $this->Html->link($uam->group->name, ['controller' => 'Groups', 'action' => 'view', $uam->group->id]) : '' ?></td>
                    <td><?= h($uam->controller) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $uam->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $uam->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $uam->id], ['confirm' => __('Are you sure you want to delete # {0}?', $uam->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
