<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Uam $uam
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Uam'), ['action' => 'edit', $uam->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Uam'), ['action' => 'delete', $uam->id], ['confirm' => __('Are you sure you want to delete # {0}?', $uam->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Uams'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Uam'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="uams view content">
            <h3><?= h($uam->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Group') ?></th>
                    <td><?= $uam->has('group') ? $this->Html->link($uam->group->name, ['controller' => 'Groups', 'action' => 'view', $uam->group->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Controller') ?></th>
                    <td><?= h($uam->controller) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($uam->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Actions') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($uam->actions)); ?>
                </blockquote>
            </div>
        </div>
    </div>
</div>
