<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Worksheet $worksheet
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $worksheet->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $worksheet->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Worksheets'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="worksheets form content">
            <?= $this->Form->create($worksheet) ?>
            <fieldset>
                <legend><?= __('Edit Worksheet') ?></legend>
                <?php
                    echo $this->Form->control('EntryID');
                    echo $this->Form->control('AccountCode');
                    echo $this->Form->control('Description');
                    echo $this->Form->control('Bal_Dr');
                    echo $this->Form->control('Bal_Cr');
                    echo $this->Form->control('CT_Dr');
                    echo $this->Form->control('CT_Cr');
                    echo $this->Form->control('UTB_Dr');
                    echo $this->Form->control('UTB_Cr');
                    echo $this->Form->control('CurentAdj_Dr');
                    echo $this->Form->control('CurrentAdj_Cr');
                    echo $this->Form->control('AdjTB_Dr');
                    echo $this->Form->control('AdjTB_Cr');
                    echo $this->Form->control('IS_Dr');
                    echo $this->Form->control('IS_Cr');
                    echo $this->Form->control('BS_Dr');
                    echo $this->Form->control('BS_Cr');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
