<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;

class ChartofaccountsController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
   public function index(){
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Chartofaccounts.id' => "DESC"]; //$columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Chartofaccounts.AccountTitle' => $searchValue];									
			}
			
			$where[] = ['Chartofaccounts.id >' => 0];
			
			$q1 = $this->Chartofaccounts->find()
					->where($where)
					->contain([])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Chartofaccounts->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Chartofaccounts->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			
			if(!empty($datas)):
				foreach($datas as $u):
					$_link = Router::url(
						['controller' => 'chartofaccounts', 'action' => 'view', $u->id]
					);
					
					
					
					$view_link = '<a href="'.$_link.'" 
					title ="Account Details" 
					class = "dropdown-item btn btn-xs btn-outline-success"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> Details</div></a>';
					
					$link2 = '<a href="'.$_link.'" 
					title ="Member Profile" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view text-black bold">'.$u->name.'</a>';
					
					$update_link = Router::url(
						['controller' => 'chartofaccounts', 'action' => 'edit', $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Update Chart of Account" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Update</div></a>';
					
					$actions = $view_link . $update_link;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                           
                           '.$actions.'
                          </div>
                        </div>';
						
					
								
				   $_data[] = array( 
						'code'			=> '<span class="bold text-primary">'.$u->AccountCode.'</span>',
						'title'			=> '<span class="bold text-uppercase text-black">'.$u->AccountTitle.'</span>',	
						'status'		=> '<span class="bold text-'.($u->status=="ACTIVE" ? "success" : "danger").'">'.$u->status.'</span>',	
						'created'		=> '<span class="bold">'.$u->EntryDate.'</span>',					
						'update'		=> '<span class="bold">'.$u->UpdateDateTime.'</span>',							
						'action'		=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	public function view($id=null){
		 $chart = $this->Chartofaccounts->find()
		->contain([])
		->where(['Chartofaccounts.id' => $id])
		->first();
		
		$this->set(compact('chart'));
		
	}
	
	public function add(){
			

			$chart = $this->Chartofaccounts->newEmptyEntity();
			if ($this->request->is('post')) {
				$this->ajaxLayout();
				$code = 0;
				
				$data = $this->request->getData();				
				$chart = $this->Chartofaccounts->patchEntity($chart, $data,  ['validate' => false]);
				
				$error = $this->showError($chart);
						
				if(!empty($error)) {
					$this->Log(json_encode($chart->getErrors()));
					$msg = '<span class="text-danger">'.$error.'</span>';
				}else{
					
					$chart->EntryDate = date("Y-m-d H:i:s");
					
					if ($this->Chartofaccounts->save($chart)) {
						
						
						$code = 1; 
						$msg = '<div class="text-success">New Chart of account successfully registered</div>';

					}else{
						$error = $this->showError($chart);
						$this->Log(json_encode($chart->getErrors()));
						$msg = '<span class="text-danger">'.$error.'</span>';
					}
				} 
					
				$resp = ['code' => $code, 'msg' => $msg];
				
				
				$this->response = $this->response->withType('application/json')
				->withStringBody(json_encode($resp));
				
				return $this->response;
			}

			$this->set(compact('chart'));
		
    }
	
	public function edit($id=null, $issave=false){
				
			
			$chart = $this->Chartofaccounts->get($id, [
				'contain' => [],
			]);
			
			
			if($this->request->is('ajax') && $issave) {
					$this->log(json_encode($this->request->getData()));
					$this->ajaxLayout();
					$code = 0;
				
						$data = $this->request->getData();				
						$chart = $this->Chartofaccounts->patchEntity($chart, $data);
						
						$error = $this->showError($chart);
								
						if(!empty($error)) {
							$this->Log(json_encode($chart->getErrors()));
							$msg = '<span class="text-danger">'.$error.'</span>';
						}else{
							
							$chart->UpdateDateTime = date("Y-m-d H:i:s");
							
							if ($this->Chartofaccounts->save($chart)) {
								
								$code = 1; 
								$msg = '<div class="text-success">Data changes has been saved.</div>';
								
							}else{
								$error = $this->showError($chart);
								$this->Log(json_encode($chart->getErrors()));
								$msg = '<span class="text-danger">'.$error.'</span>';
							}
						} 
							
						$resp = ['code' => $code, 'msg' => $msg];
						
						
						$this->response = $this->response->withType('application/json')
						->withStringBody(json_encode($resp));
						
						return $this->response;
			}
			
			$this->set(compact('chart'));
			
		
    }
	
	
	
   
}
