<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Loandetails Controller
 *
 * @property \App\Model\Table\LoandetailsTable $Loandetails
 * @method \App\Model\Entity\Loandetail[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class LoandetailsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $loandetails = $this->paginate($this->Loandetails);

        $this->set(compact('loandetails'));
    }

    /**
     * View method
     *
     * @param string|null $id Loandetail id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $loandetail = $this->Loandetails->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('loandetail'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $loandetail = $this->Loandetails->newEmptyEntity();
        if ($this->request->is('post')) {
            $loandetail = $this->Loandetails->patchEntity($loandetail, $this->request->getData());
            if ($this->Loandetails->save($loandetail)) {
                $this->Flash->success(__('The loandetail has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The loandetail could not be saved. Please, try again.'));
        }
        $this->set(compact('loandetail'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Loandetail id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $loandetail = $this->Loandetails->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $loandetail = $this->Loandetails->patchEntity($loandetail, $this->request->getData());
            if ($this->Loandetails->save($loandetail)) {
                $this->Flash->success(__('The loandetail has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The loandetail could not be saved. Please, try again.'));
        }
        $this->set(compact('loandetail'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Loandetail id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $loandetail = $this->Loandetails->get($id);
        if ($this->Loandetails->delete($loandetail)) {
            $this->Flash->success(__('The loandetail has been deleted.'));
        } else {
            $this->Flash->error(__('The loandetail could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
