<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;
use Cake\View\Helper\HtmlHelper;
use Cake\Event\EventInterface;


class RolesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
    public function index(){
     
    }
	
	
	private function removeFromString($windows, $assigned) {
		
		//$this->ajaxLayout();
		//$windows = '1,2,3';
		//$assigned = '1,2,3,4,5,6';
		
		if( strpos($windows, ",") !== false ) {
			$windows  	= explode(",", $windows);
		}else{
			$windows 	= array($windows);
		}
		
		if( strpos($assigned, ",") !== false ) {
			$assigned  	= explode(",", $assigned);
		}else{
			$assigned 	= array($assigned);
		}
		
		$clean = array_diff($assigned, $windows); 
		//$clean2 = array_diff($assigned, $windows); 
		//$final_output = array_merge($clean1, $clean2);
		
		return !empty($clean) ? implode(",", $clean) : "";
	}

	public function removewindows($id){
		$this->ajaxLayout();
		$role = $this->Roles->get($id, [
			'contain' => [],
		]);
			
		if($this->request->is('ajax')){
			$role = $this->Roles->patchEntity($role, ['validation' => false]);
			
			$msg = '<span class="text-danger">Unable to process your request</span>';
			
			$settings = $this->getTableLocator()->get('Qsettings');
			$setting = $settings->get(1, ['contain' => []]);				

			$setting->assigned = $this->removeFromString($role->windows, $setting->assigned);
			$role->windows = '';
				
			if($this->Roles->save($role) && $settings->save($setting)){
				$msg = '<span class="text-success">All assigned windown has been removed</span>';
			}
			echo json_encode(array('resp' => 1, 'msg' => $msg));
			exit();
		}
	}
	
	public function indexajax(){		
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			switch($columnName){
				case "NAME":
					$orderby = ['Roles.name' => $columnSortOrder];
				break;
				default:
					$orderby = ['Roles.name' => $columnSortOrder];
				break;
			}
			
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Roles.name LIKE' => '%'.$searchValue.'%'];
			}

			$where[] = ['Roles.id >' => 1];
			
			$q1 		= $this->Roles->find()
							->where($where)
							->contain([])
							->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Roles->find()
					->where($where)
					->contain(['Users'])
					->order($orderby);
			}else{	
				$datas = $this->Roles->find()
					->where($where)
					->contain(['Users'])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			if(!empty($datas)):
				foreach($datas as $u):
					
					
					$update_link = Router::url(
						['controller' => 'roles', 'action' => 'edit', $u->id]
					);
					
					$remove_link = Router::url(
						['controller' => 'roles', 'action' => 'removewindows', $u->id]
					);
					
					
					
					$link = '<a href="'.$update_link.'" 
					title ="Update Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Make Changes</div></a>';

					$link1 = '<a href="'.$update_link.'" 
					title ="Update Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-cog menu-icon"></i> UAM Settings</div></a>';
					
					$actions = $link . $link1;
					
				/* 	$link .= '<a href="'.$remove_link.'" 
					title ="Remove Assigned Window(s)" 
					class = "btn btn-xs btn-outline-danger m-l-5 modal_remove"><div class="preview-thumbnail">
					<i class="typcn typcn-delete menu-icon"></i></div></a>'; */
					
						$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                            <h6 class="dropdown-header">Action</h6>
                           '.$actions.'
                          </div>
                        </div>';
						
				   $_data[] = array( 
						'role'		=> $u->id,
						'name'		=> $u->name,
						'tag'		=> count($u->users),
						'action'	=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	 public function add(){
        $role = $this->Roles->newEmptyEntity();
		//$settings = $this->loadSettings();		
		$this->set(compact('role'));
		
       if ($this->request->is('post')) {
			$this->ajaxLayout();
			$resp = 0;
			$data = $this->request->getData();
			
			
			
			 $role = $this->Roles->patchEntity($role, $data);
					$error = $this->showError($role);
					
					if(!empty($error)) {
						$this->Log(json_encode($role->getErrors()));
						$msg = '<span class="text-danger">'.$error.'</span>';
					}else{
						//$role->windows = implode(",", $data['windows']);
						$role->name = strtoupper($data['name']);
						$role->slug = str_replace(" ", "", strtolower($data['name']));
						if ($this->Roles->save($role)) {
							$resp = 1;
							$msg = '<span class="text-success">User group successfully saved</span>';
							
						}else{
							$error = $this->showError($role);
							$this->Log(json_encode($role->getErrors()));
							$msg = '<span class="text-danger">'.$error.'</span>';
						}
					} 
					
				echo json_encode(array('resp' => $resp, 'msg' => $msg));
				die();
		}
		
    }

  
   public function edit($id=null){
	
        $role = $this->Roles->get($id, [
            'contain' => [],
        ]);
	     
		$settings = $this->loadSettings();				
		$this->set(compact('role', 'settings'));
		
		if ($this->request->is(['put', 'post'])) {
					$this->ajaxLayout();
					$resp = 0;
					$data = $this->request->getData();
					$role = $this->Roles->patchEntity($role, $this->request->getData());
					$error = $this->showError($role);
					
						if(!empty($error)){
							//$this->Log(json_encode($user->getErrors()));
							$msg = '<span class="text-danger">Save failed. '.$error.'</span>';
						}else{
							$role->name = strtoupper($data['name']);
							$role->slug = str_replace(" ", "", strtolower($data['name']));
							//if(!empty($data['windows'])){
								//$new_assigned  = implode(",", $data['windows']);
								//$role->windows = $new_assigned;
								
								if ($this->Roles->save($role)) {
									//$this->saveAssigned($new_assigned);
									//$this->Flash->success('Member successfully registered.')
									//return $this->redirect(['action' => 'add']);
									$resp = 1;
									$msg = '<span class="text-success">Changes successfully saved</span>';
								}else{
									$msg = '<span class="text-danger">Save failed. Some information were missing or invalid.</span>';
								}
							//}else{
								//$msg = '<span class="text-danger">You have to assign at least one (1) window.</span>';
							//}
						}
		
					echo json_encode(array('resp' => $resp, 'msg' => $msg));
					die();
		}
    }
	
	private function saveAssigned($new_assigned){
		$settings = $this->getTableLocator()->get('Qsettings');
		$setting = $settings->get(1, ['contain' => []]);
		$assigned = !empty($setting->assigned) ? $setting->assigned ."," : "";
		$assigned = $assigned . $new_assigned;
		$setting->assigned = $assigned;
		$settings->save($setting);
	}
	
	
}
