<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;


class SettingsController extends AppController
{	
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
    
    public function edit($id = null){       
        $setting = $this->Settings->get($id, [
            'contain' => [],
        ]);
	
		$this->set(compact('setting'));
			
		if ($this->request->is(['put', 'post'])) {
					$this->ajaxLayout();
					$resp = 0;
					$data = $this->request->getData();
					$setting = $this->Settings->patchEntity($setting, $this->request->getData());
					$error = $this->showError($setting);
					
						if(!empty($error)){
							//$this->Log(json_encode($user->getErrors()));
							$msg = '<span class="text-danger">Save failed. '.$error.'</span>';
						}else{
							if ($this->Settings->save($setting)) {
								//$this->Flash->success('Member successfully registered.')
								//return $this->redirect(['action' => 'add']);
								$resp = 1;
								$msg = '<span class="text-success">Changes successfully saved</span>';
							}else{
								$msg = '<span class="text-danger">Save failed. Some information were missing or invalid.</span>';
							}
						}
		
					echo json_encode(array('resp' => $resp, 'msg' => $msg));
					die();
				
		}
    }
	
	private function resizeImage($resourceType, $image_width, $image_height, $resizeWidth, $resizeHeight){
		$imageLayer = imagecreatetruecolor($resizeWidth, $resizeHeight);
		imagecopyresampled($imageLayer, $resourceType, 0, 0, 0, 0, $resizeWidth, $resizeHeight, $image_width, $image_height);
		return $imageLayer;
	}	
	
	public function dashboard(){
		// In a controller or service class

		$loanMastersTable = \Cake\ORM\TableRegistry::getTableLocator()->get('Loanmasters');
		$totalApprovedLoanAmount = $loanMastersTable->getTotalApprovedLoanAmountForCurrentYear();
		$loanTotals = $loanMastersTable->getLoanTotalsForCurrentYear();			
		$monthlyCounts = $loanMastersTable->countIdsByMonth();
		
		$memberCapitalBuildupsTable = \Cake\ORM\TableRegistry::getTableLocator()->get('Membercapitalbuildups');
		$totalMonthlyCbu = $memberCapitalBuildupsTable->sumTotalMonthlyCbu();
		
		$membersTable = \Cake\ORM\TableRegistry::getTableLocator()->get('Members');
		$totalMembers = $membersTable->countAllMembers();
		$totalNetAmountOfLoan = $loanMastersTable->computeTotalNetAmountOfLoan();
		
		$this->set(compact('totalApprovedLoanAmount', 'loanTotals'));
		$this->set('monthlyCounts', json_encode(array_values($monthlyCounts)));
		$this->set('totalMonthlyCbu', $totalMonthlyCbu);
		$this->set('totalMembers', $totalMembers);
		$this->set('totalNetAmountOfLoan', $totalNetAmountOfLoan);
	}
	

	public function uploadavatar(){
		if($this->request->is('ajax')){
			
			$this->ajaxLayout();
			$respcode 		= 1;
			$_data 	  		= '';
			$msg			= '';
			$row 			= 1;
			$_added 		= 0;
			$_notadded 		= 0;
			$ndata			= array();
			$imgg			= '';
			
			if(isset($_FILES["defaultform"])){
				$error = $_FILES["defaultform"]["error"];						
				if($error){
					$msg = "You have uploaded an invalid file";
				}else{
					if(!is_array($_FILES["defaultform"]["name"])){
							

							$refid				= $_POST['refid'];
							
							$fileName 			= $_FILES["defaultform"];	
							$extension 			= pathinfo($fileName['name'], PATHINFO_EXTENSION);
							$new_file_name   	= $refid . date('YmdHis');
							$sourceProperties 	= getimagesize($fileName['tmp_name']);				
							$uploadImageType 	= $sourceProperties[2];
							$sourceImageWidth 	= $sourceProperties[0];
							$sourceImageHeight 	= $sourceProperties[1];
							$new_width			= intval($sourceImageWidth * 0.2);
							$new_height			= intval($sourceImageHeight * 0.2);
							$resizeFileName 	= time();
							$new_file 			= $this->imagedir('local', 1) . $new_file_name.'.'.$extension;

							switch ($uploadImageType){
								case IMAGETYPE_JPEG:
									$resourceType = imagecreatefromjpeg($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagejpeg($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break;

								case IMAGETYPE_GIF:
									$resourceType = imagecreatefromgif($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagegif($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break; 

								case IMAGETYPE_PNG:
									$resourceType = imagecreatefrompng($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagepng($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break;

								case IMAGETYPE_JPG:
									$resourceType = imagecreatefrompng($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagepng($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break;
								default:
									$respcode = 0;
								break;
							}
						
						
						if($respcode==1){
							$imgg 						= $this->imagedir('url') . date('Y').'/'.date('m').'/'.$new_file_name.'.'.$extension;
							$image_to_save 		= $this->imagedir('url') . date('Y').'/'.date('m').'/'.$new_file_name.'.webp';
							//update image
							$setting = $this->Settings->get($refid, ['contain' => []]);
							
							
							if(!empty($setting)){							    
							
								$dir 				= $this->imagedir('local', 1); 
								$imagine = new \Imagine\Gd\Imagine();
								$_image = $imagine->open($imgg);
								$_image->save($dir . $new_file_name.'.webp', array('webp_quality' => 50)); 
						
						
								 $setting->logo = $image_to_save;
								 $this->Settings->save($setting);
							}
							
							$msg 		= "Image upload done!";
						}else{
							$msg 		= "Image upload failed";
						}							
						
					}else{
						$msg = "You have uploaded an invalid file";
					}
				}
			}else{
				$msg = "Unable to read the file, please try again";
			}
			
		   echo json_encode(array("respcode" => $respcode, "message" => $msg, "data" => $_data, "img" => $imgg));	
			die();
		}
	}
	


}
