<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Transactionlogs Controller
 *
 * @property \App\Model\Table\TransactionlogsTable $Transactionlogs
 * @method \App\Model\Entity\Transactionlog[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class TransactionlogsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $transactionlogs = $this->paginate($this->Transactionlogs);

        $this->set(compact('transactionlogs'));
    }

    /**
     * View method
     *
     * @param string|null $id Transactionlog id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $transactionlog = $this->Transactionlogs->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('transactionlog'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $transactionlog = $this->Transactionlogs->newEmptyEntity();
        if ($this->request->is('post')) {
            $transactionlog = $this->Transactionlogs->patchEntity($transactionlog, $this->request->getData());
            if ($this->Transactionlogs->save($transactionlog)) {
                $this->Flash->success(__('The transactionlog has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The transactionlog could not be saved. Please, try again.'));
        }
        $this->set(compact('transactionlog'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Transactionlog id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $transactionlog = $this->Transactionlogs->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $transactionlog = $this->Transactionlogs->patchEntity($transactionlog, $this->request->getData());
            if ($this->Transactionlogs->save($transactionlog)) {
                $this->Flash->success(__('The transactionlog has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The transactionlog could not be saved. Please, try again.'));
        }
        $this->set(compact('transactionlog'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Transactionlog id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $transactionlog = $this->Transactionlogs->get($id);
        if ($this->Transactionlogs->delete($transactionlog)) {
            $this->Flash->success(__('The transactionlog has been deleted.'));
        } else {
            $this->Flash->error(__('The transactionlog could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
