<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;


use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;
use Cake\View\Helper\HtmlHelper;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;
use Cake\Event\EventInterface;

use Cake\Utility\Inflector;

use Cake\Http\Response;
use Endroid\QrCode\QrCode;
use Endroid\QrCode\Writer\PngWriter;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsersController extends AppController
{
		
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
	// in src/Controller/UsersController.php
	
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
		
		//$this->Users->query("SET sql_mode=(SELECT REPLACE(@@sql_mode, 'ONLY_FULL_GROUP_BY', ''));");
		
		//$this->set('title', 'Users Masterlist ' .date('Y-m-d'));
		//$this->Authentication->allowUnauthenticated(['login', 'register', 'unauthorized']);
	}
	
	public function attendancereport(){
		
	}
	
	public function userreport(){
	
	}
	
	public function unauthorized(){
		
	}
	
	public function generatesingleqrcode(){
		
	}
	
	
	public function generateQrCode($id=null)
    {
        // Data to be encoded in the QR Code
		
		$user = $this->Users->get($id, ['contain' => []]);
		
		$data = [
			'refid'		=> $user->refid,
			'code' 		=> $user->username,
			'id' 		=> $user->contact_no,
			'pw'		=> $user->password			
		];
		$this->log("DATA " .json_encode($data));
		$data = base64_encode(json_encode($data));		 
		$data = $this->qrweburl() .$data;
		
		$this->log("URL " . $user->otp." " .$data);
        // Create a QR code object
        $qrCode = QrCode::create($data)
                        ->setSize(500)
                        ->setMargin(10);

        // Create a writer instance
        $writer = new PngWriter();

        // Generate the QR code image
        $result = $writer->write($qrCode);

        // Get QR code image data as string
        $qrCodeString = $result->getString();

        // Create a response with the QR code PNG image
        $response = $this->response->withType('image/png')
                                   ->withStringBody($qrCodeString);

        // Disable CakePHP's default layout rendering
        $this->viewBuilder()->disableAutoLayout();

        return $response;
    }
	
	public function generatePassword()
    {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';

        for ($i = 0; $i < 16; $i++) {
            $randomString .= $characters[random_int(0, $charactersLength - 1)];
        }

        return $randomString;
    }
	
	public function generateMassOTP(){
		$this->ajaxLayout();
		
		$users = $this->Users->find()
		->where(['id >' => 1])
		->contain([])
		->all();
		
		foreach($users as $user):
			$otp = $this->Common->generateOTP();
			$user->otp = $otp;
			$this->Users->save($user);			
		endforeach;
		
		
	}
	
	
	public function generateaccounts(){
		$this->ajaxLayout();
		$membersTable = $this->getTableLocator()->get('Members');
		$usersTable = $this->getTableLocator()->get('Users');
		$result = "";
		$members = $membersTable->find()
		->order(['LastName'])
		->all();
		
		$data = [];
		/* foreach($members as $member):
			$data[] = [
				'refid' => "000000",
				'role_id' => 22,
				'name' => $member->FirstName.' '.$member->LastName,
				'contact_no' => $member->id,
				'username' => $this->Common->generateOTP(),
				'password' => $this->generatePassword(),
				'created' => date("Y-m-d H:s:i"),
				'status' => "ACTIVE",							
				'avatar' => $member->DateOfBirth
			];			
		endforeach;
		
		if (!empty($data)) {
        $users = $usersTable->newEntities($data);
        $result = $usersTable->saveMany($users);

			if (!$result) {
				// Handling save error
				$errorMessages = [];
				foreach ($users as $user) {
					if ($user->getErrors()) {
						$errorMessages[] = $user->getErrors();
					}
				}
				echo json_encode(['success' => false, 'errors' => $errorMessages]);
			} else {
				echo json_encode(['success' => true, 'result' => $result]);
			}
		} else {
			echo json_encode(['success' => false, 'message' => 'No data to save']);
		}
		exit(); */
		
		foreach ($members as $member) {
			$userData = [
				'refid' => "000000",
				'role_id' => 22,
				'name' => $member->firstname . ' ' . $member->lastname,
				'contact_no' => $member->id,
				'username' => $this->Common->generateOTP(),
				'password' => $this->generatePassword(),
				'created' => date("Y-m-d H:s:i"),
				'otp' => $this->Common->generateOTP(),
				'otp_generated' => date("Y-m-d H:s:i"),
				'status' => "ACTIVE",
				'avatar' => $member->dateofbirth
			];

			$user = $usersTable->newEntity($userData);
			if ($usersTable->save($user)) {
				// Update the member with the new user ID
				$member->user_id = $user->id;
				$membersTable->save($member);
			} else {
				// Handle the error
				$errorMessages = $user->getErrors();
				echo json_encode(['success' => false, 'errors' => $errorMessages]);
				exit();
			}
		}

		echo json_encode(['success' => true, 'message' => 'All users and members updated successfully']);
		exit();
		
	}
	
	
	public function showdir(){
		$this->ajaxLayout();
		echo $_SERVER['DOCUMENT_ROOT'];
	}
	
	public function index(){

			if($this->request->is('post')){
				
				$data 			= $this->request->getData();
				$role				= (isset($data['role_id']) && !empty($data['role_id']) ? $data['role_id'] : '');
				$status			= (isset($data['status']) && !empty($data['status']) ? $data['status'] : '');
			
				$data = $this->request->getData();
				if($data['status'] == "ALL"){
					$role_id 	= $data['role_id'];
					$users = $this->Users->find()
					->where(['role_id' => $data['role_id']])
					->contain(['Roles'])
					->all();
				}else{
					$role_id 	= $data['role_id'];
					$status 	= $data['status'];
					
					$users = $this->Users->find()
					->where(['role_id' => $data['role_id'], 'status' => $data['status']])
					->contain(['Roles'])
					->all();
				}
			}else{
				$role = '0';
				$status = 'ALL';
			}
			
			$this->set('status', $status);
			$this->set('role', $role);

			$roles = $this->Users->Roles->find('list')
			->where(function ($exp, $roles) {
					return $exp->gt('id', 1);
			})
			->contain([])
			->order(['name' => 'ASC']); 
				
			$this->set(compact('roles')); 
			
	}
	
	public function dashboard(){
		
	}
	
	public function indexajax($role=null, $status=null){
		
		
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			switch($columnName){
				case "NAME":
					$orderby = ['Users.name' => $columnSortOrder];
				break;
				default:
					$orderby = ['Users.name' => $columnSortOrder];
				break;
			}
			
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Users.name LIKE' => '%'.$searchValue.'%'];
			}
			
			if(!empty($role)){
				if($role !==0){
					$where[] = ['Users.role_id' => $role];
				}
			}
			
			if(!empty($status)){
				if($status !=="ALL"){
					$where[] = ['Users.status' => $status];					
				}
			}
			
			$where[] = ['Users.id >' => 1];
			
			$q1 		= $this->Users->find()
							->where($where)
							->contain([])
							->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$users = $this->Users->find()
					->where($where)
					->contain(['Roles'])
					->order($orderby);
			}else{	
				$users = $this->Users->find()
					->where($where)
					->contain(['Roles'])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			$total_sales = 0;
			if(!empty($users)):
				foreach($users as $u):
					
					$total_sales = "0.00";
					
					if(!empty($u->avatar)){
						$img = '<img src="'. $this->imagedir("url").'no_image.jpg" />';		
						//$img = '<img src="'.$u->avatar.'" alt="image" class="profile-pic" />';
					}else{
						$img = '<img src="'. $this->imagedir("url").'no_image.jpg" />';						
					}
											
					$_link = Router::url(
						['controller' => 'users', 'action' => 'view-user-profile/'.$u->refid.'-'.$u->id]
					);
					
					$link = '<a href="'.$_link.'" 
					title ="Account Details" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "modal_view dropdown-item"><div class="preview-thumbnail">'.$img.'</div></a>';
					
					$view_link = '<a href="'.$_link.'" 
					title ="Account Details" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> View Details</div></a>';
					
					$link2 = '<a href="'.$_link.'" 
					title ="Member Profile" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view text-black bold">'.$u->name.'</a>';
					
					$update_link = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->refid, $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Update Account" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Make Changes</div></a>';
					
					$reassign = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->refid, $u->id, "reassign"]
					);
					
					$reassign = '<a href="'.$reassign.'" 
					title ="Change Account Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-user menu-icon"></i> Change Role</div></a>';

					$actions = $view_link . $update_link . $reassign;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                            <h6 class="dropdown-header">Action</h6>
                           '.$actions.'
                          </div>
                        </div>';
						
				   $_data[] = array( 
						'image'				=> $link,
						'name'				=> $link2,
						'role'				=> $u->role->name,
						'contact'			=> '<div class="bold">'.$u->contact_no.'</div>',
						'last_access'		=> '<div class="bold">'.$u->last_login.'</div>',
						'total_sales'		=> '<div class="bold">'.$u->username.'</div>',
						'status'				=> '<div class="bold status_t'.$u->id.'">'.$u->status.'</div>',
						'action'				=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
    public function index2(){
		$role_id 	= 2;
		$status 	= "all";
		
		if($this->request->is('post')){
			$data = $this->request->getData();
			if($data['status'] == "ALL"){
				$role_id 	= $data['role_id'];
				$users = $this->Users->find()
				->where(['role_id' => $data['role_id']])
				->contain(['Roles'])
				->all();
			}else{
				$role_id 	= $data['role_id'];
				$status 	= $data['status'];
				
				$users = $this->Users->find()
				->where(['role_id' => $data['role_id'], 'status' => $data['status']])
				->contain(['Roles'])
				->all();
			}
		}else{
						
			$users = $this->Users->find()
			->where(function ($exp, $users) {
				return $exp->gt('role_id', 1);
			})
			->contain(['Roles'])
			->all(); 
		}
		
		$this->set('role_id', $role_id);
		$this->set('status', $status);
		
		
		$roles = $this->Users->Roles->find('list')
		->where(function ($exp, $roles) {
				return $exp->gt('id', 1);
		})
		->contain([])
		->order(['name' => 'ASC']); 
			
        $this->set(compact('users', 'roles')); 
    }
	
	public function updateuserstatus($id, $status){
		$this->ajaxLayout();
		if($this->request->is('ajax')){
			$user = $this->Users->get($id, ['contain' => []]);
			$user->status = $status;
			$this->Users->save($user);
			//echo json_encode(array('resp' => $resp, 'msg' => $msg));
			exit();
		}
	}
	
	public function download(){
		$role_id 			= $this->request->getParam('role_id');
		$this->Log(json_encode($this->request->getParam('role_id')));
		$status	 			= $this->request->getParam('status');
		//$status 			= strtoupper(str_replace("-", "", $status));
		$download_type	 	= $this->request->getParam('download_type');
		
		//$this->viewBuilder()->template('file');
		$el_name 		= "all_account";
		$report_name 	= "List of Accounts";
		$account_role 	= "All";
		$account_status = "All";
		
		switch($role_id){
			case "all":
				switch($status){
					case "all":
						$users = $this->Users->find()
						->contain(['Roles'])
						->all();		
					break;
					default:
						$account_status = $status;
						$users = $this->Users->find()
						->where(['status' => $status])
						->contain(['Roles'])
						->all();
					break;
				}
			break;
			default:
				$group = $this->Users->Roles->get($role_id, ['contain' => []]);
				$account_role = $group->name;
				$el_name	  = $el_name ."-".$group->name;
				switch($status){
					case "all":
						$users = $this->Users->find()
						->where(['role_id' => $role_id])
						->contain(['Roles'])
						->all();	
					break;
					default:
						$account_status = $status;
						$users = $this->Users->find()
						->where(['role_id' => $role_id, 'status' => $status])
						->contain(['Roles'])
						->all();	
					break;
				}
			break;
		}
		
		$this->set('users', $users);
		$this->set('report_name', strtoupper($report_name));
		$this->set('account_role', strtoupper($account_role));
		$this->set('account_status',strtoupper( $account_status));
		
		switch($download_type){
			case "pdf":
				$this->viewBuilder()->enableAutoLayout(false); 
				$this->viewBuilder()->setClassName('CakePdf.Pdf');
				$this->viewBuilder()->setOption(
					'pdfConfig',
					[
						'orientation' => 'portrait',
						'download' => true, // This can be omitted if "filename" is specified.
						//'print' => true,
						'filename' => 'list_of_cadidate_'.$el_name.'.pdf' //// This can be omitted if you want file name based on URL.
						//'filename' => \Cake\Utility\Text::slug($report->title) . '-' . __('Report') . '.pdf' //If you want to use the title as the filename
					]
				);
			break;
			case "xls":
				$spreadsheet = new Spreadsheet();
				$sheet = $spreadsheet->getActiveSheet();
				$sheet->setCellValue('A1', 'Hello World !');

				$writer = new Xlsx($spreadsheet);
				$file = 'list_of_cadidate_'.$el_name.'.xlsx';
				$writer->save('report/'.$file);
				
				$this->viewClass = 'Media';
				$file_path = WWW_ROOT.'report'.DS. $file;
				
				return $this->response->withFile($file_path, [
					'download' => true,
					'name' => $file
				]);
				
			break;
			default:
				
			break;
		} 
		
	}

	
	public function generatecode(){
		$step = $this->request->getParam("step");
		$type = $this->request->getParam("type");
	}
	

	public function printqrcode($id=null){
		$user = $this->Users->newEmptyEntity();
		$this->set(compact('user'));
		
		$last_user = $this->Users->find()
		->select(['id'])
		->contain([])
		->last();
		
		$this->set('last_user', $last_user);
		
		if($this->request->is('post') || (isset($id) && !empty($id))){
			$data = $this->request->getData();
			
			
			if(isset($id) && !empty($id)){
				$from 	= $id;
				$to 	= $id;
			}else{
				$from 	= $data['fromid'];
				$to 	= $data['toid'];
			}
			
				$allusers = $this->Users->find()
				->select(['lastname', 'firstname', 'member_no', 'contact_no', 'otp', 'id'])
				->where(['id >=' => $from, 'id <=' => $to, 'status' => 'ACTIVE'])
				->order(['lastname' => 'ASC'])
				->contain([])		
				//->limit(100)
				->all();
				
			
			$this->set('allusers', $allusers);
			
			$dir = $this->qrcodedir("url");
			$this->set('dir', $dir);
			
			 $this->viewBuilder()->enableAutoLayout(false); 
			$this->viewBuilder()->setClassName('CakePdf.Pdf');
			$this->viewBuilder()->setOption(
			'pdfConfig',
				[
				'orientation' => 'portrait',
				'download' => true, // This can be omitted if "filename" is specified.
				//'print' => true,
				'filename' => 'members_code_otp_'.date('Y-m-d').'.pdf' //// This can be omitted if you want file name based on URL.
				//'filename' => \Cake\Utility\Text::slug($report->title) . '-' . __('Report') . '.pdf' //If you want to use the title as the filename
				]
			); 
		}
	}
	
	public function downloadcode(){
		
		
		/* $users = $this->Users->find()
		->where([
			'id >' => 1, 
			'status' => 'ACTIVE', 
			'OR' => [['DATE(otp_generated) < ' => date('Y-m-d')], ['otp_generated' => '']]
		])
		->contain([])
		->all();
		
		foreach($users as $u):
			
				$code = strtolower($this->Common->generateString());
				$u->otp 			= $this->Common->generateOTP();	
				$u->otp_generated 	= date('Y-m-d H:i:s');
				$u->code 	 		= $code;
				$u->password 	 	= $code;			
				$this->Users->save($u);
		
		endforeach;
		 */
		 
		$allusers = $this->Users->find()
		->select(['lastname', 'firstname', 'otp', 'id'])
		//->where(['id >' => 1, 'status' => 'ACTIVE'])
		->where(function ($exp, $allusers) {
					return $exp->eq('status', 'ACTIVE')
					->gt('id', 1845)
					->lt('id', 1945);
					/*->gt('id', 601) //batch 7
					->lt('id', 701);*/ 
					/*->gt('id', 501) //batch 6
					->lt('id', 601);*/
					
		})
		->order(['lastname' => 'ASC'])
		->contain([])		
		//->limit(100)
		->all();
		
		$this->set('allusers', $allusers);
		
		$dir = $this->qrcodedir("url");
		$this->set('dir', $dir);
		
		 $this->viewBuilder()->enableAutoLayout(false); 
		$this->viewBuilder()->setClassName('CakePdf.Pdf');
		$this->viewBuilder()->setOption(
		'pdfConfig',
			[
			'orientation' => 'portrait',
			'download' => true, // This can be omitted if "filename" is specified.
			//'print' => true,
			'filename' => 'members_code_otp_'.date('Y-m-d').'.pdf' //// This can be omitted if you want file name based on URL.
			//'filename' => \Cake\Utility\Text::slug($report->title) . '-' . __('Report') . '.pdf' //If you want to use the title as the filename
			]
		);  
		
	}
	
	
	public function qrcodefinder($cid = null){
		
		if($this->request->is('ajax')){
			$this->viewBuilder()->setLayout('ajax');
			if(!empty($cid)){
				$user = $this->Users->find()
				->where(['member_no' => $cid])
				->contain([])
				->first();
				
				$dir = $this->qrcodedir("url");
				$this->set('dir', $dir);
				$this->set('user', $user);
			}
			
		}else{
			$this->viewBuilder()->setLayout('login');
		}
		
		$this->set('cid', $cid);
	}
	
	public function login(){
		//$this->Authorization->skipAuthorization();
		$result = $this->Authentication->getResult();
		// If the user is logged in send them away.
		if ($result->isValid()) {
			$user = $result->getData();

			if($user->role_id == 1) { //administrator
				$target = $this->Authentication->getLoginRedirect() ?? '/admin/elections/dashboard';
			}else{
				$target = $this->Authentication->getLoginRedirect() ?? '/users/index';
			}
				return $this->redirect($target);
		}
		
		if ($this->request->is('post')) {
			$this->Flash->error('Invalid username or password');
		}
	}
	
	public function logout(){
		//$this->Authorization->skipAuthorization();
		$this->Authentication->logout();
		return $this->redirect(['controller' => 'Users', 'action' => 'login']);
	}
	
	public function register(){
		$user = $this->Users->newEmptyEntity();
        if ($this->request->is('post')) {
            $user = $this->Users->patchEntity($user, $this->request->getData());
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $groups = $this->Users->Roles->find('list', ['limit' => 200])->all();
        $this->set(compact('user', 'groups'));
	}
	

    public function view(){
	
		$id 	= $this->request->getParam('id');
		$refid 	= $this->request->getParam('refid');
		
        $user = $this->Users->get($id, [
            'contain' => ['Roles'],
        ]);
		
		$dir = $this->qrcodedir("url");
		$this->set('dir', $dir);
			
        $this->set(compact('user')); 
    }
	
	public function myprofile(){
		$user	= $this->getCurrentUser();
		$id 	= $user['id'];
		
		  $user = $this->Users->get($id, [
            'contain' => [],
        ]);
	
        $roles = $this->Users->Roles->find('list');
		$this->set(compact('user', 'roles'));
		
		if ($this->request->is(['put', 'post'])) {
					$this->ajaxLayout();
					$resp = 0;
					$data = $this->request->getData();
					$user = $this->Users->patchEntity($user, $this->request->getData());
					$error = $this->showError($user);
						
						
						if(!empty($error)){
							//$this->Log(json_encode($user->getErrors()));
							$msg = '<span class="text-danger">Save failed. '.$error.'</span>';
						}else{
							if(isset($data['n_password']) && !empty($data['n_password'])){
								$user->password = $data['n_password'];
							}
							
							if ($this->Users->save($user)) {
								//$this->Flash->success('Member successfully registered.')
								//return $this->redirect(['action' => 'add']);
								$resp = 1;
								$msg = '<span class="text-success">Changes successfully saved. Reload the page to refresh the data.</span>';
							}else{
								$msg = '<span class="text-danger">Save failed. Some information were missing or invalid.</span>';
							}
						}
		
					echo json_encode(array('resp' => $resp, 'msg' => $msg));
					die();
				
		}
		
		
	}
	
	public function changepassword(){
		
	}
	


    public function add(){
		
			$user = $this->Users->newEmptyEntity();
			if ($this->request->is('post')) {
				$this->ajaxLayout();
				$resp = 0;
				
				$data = $this->request->getData();				
				$user = $this->Users->patchEntity($user, $data,  ['validate' => false]);
				
				$user->refid = "000000";
				//$user->role_id = 2; //member group id
				
				if(isset($data['_dob']) && !empty($data['_dob'])){
					
					if($this->checkBirthdate(date('m/d/Y', strtotime($data['_dob'])))){
						//$code 		= strtolower($this->Common->generateString());
						$otp			= $this->Common->generateOTP();
					
						//$user->username 			= substr($data['lastname'], 0, 4) . date('mdY', strtotime($data['_dob']));
						$user->username 			= $data['contact_no'];
						$user->password 			= date('mdY', strtotime($data['_dob']));
						$user->created  			= date('Y-m-d h:i:s');
						$user->otp_generated  	= date('Y-m-d H:i:s');
						$user->otp  					= $otp;
						$user->dob 					= date('Y-m-d', strtotime($data['_dob']));
						//$user->code  				= $code;
							
					
						$error = $this->showError($user);
						
						if(!empty($error)) {
							$this->Log(json_encode($user->getErrors()));
							$msg = '<span class="text-danger">'.$error.'</span>';
						}else{
							
							if ($this->Users->save($user)) {
								$resp = 1; 
								$msg = '<span class="text-success">Employee successfully registered</span>';
							 }else{
								$error = $this->showError($user);
								$this->Log(json_encode($user->getErrors()));
								$msg = '<span class="text-danger">'.$error.'</span>';
							}
						} 
					}else{
						$msg = '<span class="text-danger">Invalid Date of Birth</span>';
					}
				}else{
					$msg = '<span class="text-danger">Invalid Data Please try again</span>';
				}
				
				echo json_encode(array('resp' => $resp, 'msg' => $msg));
				die();
			}
			
			
			$roles = $this->Users->Roles->find('list')->where(['id >' => 1])->all();
			$this->set(compact('user', 'roles'));
		
    }
	
	private function checkBirthdate($dob=null){
		
		$dob = trim($dob);
		$dob = str_replace("/", "", $dob);
		$mo = substr($dob, 0, 2);
		$dy = substr($dob, 2, 2);
		$yr = substr($dob, 4, 4);
				
		if(($mo <= 12 && $dy <= 32) && $yr <= (date("Y") - 18)){
			return true;
		}
		
		return false;
		
	}
	
	public function upload(){
		
		$user = $this->Users->newEmptyEntity();
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$respcode 		= 0;
			$_data 	  		= '';
			$msg			= '';
			$row 			= 1;
			$_added 		= 0;
			$_notadded 		= 0;
			$ndata			= array();
			
			if(isset($_FILES["defaultform"])){
				$error = $_FILES["defaultform"]["error"];						
				if($error){
					$msg = "You have uploaded an invalid file";
				}else{
					if(!is_array($_FILES["defaultform"]["name"])){
						$Reader 			= new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
						$fileName 			= $_FILES["defaultform"]['tmp_name'];
						$spreadSheet 		= $Reader->load($fileName);
						$excelSheet 		= $spreadSheet->getActiveSheet();
						$sh 				= $excelSheet->toArray();
						$sheetCount 		= count($sh);
						
						$data = $this->request->getData();
						$user = $this->Users->patchEntity($user, $data);
								
						$_data ="";
						$data_array = array();
						for ($i = 1; $i <= $sheetCount; $i ++) {
							 
							
							$fname 				= !empty($sh[$i][0]) ? strtoupper($sh[$i][0]) : "";
							$mname 				= !empty($sh[$i][1]) ? strtoupper($sh[$i][1]) : "";
							$lname 				= !empty($sh[$i][2]) ? strtoupper($sh[$i][2]) : "";
							$email 				= !empty($sh[$i][3]) ? $sh[$i][3] : "";
							$mobile 			= !empty($sh[$i][4]) ? $sh[$i][4] : "";
							$emp_id 			= !empty($sh[$i][5]) ? $sh[$i][5] : "";
							$status 			= !empty($sh[$i][6]) ? strtoupper($sh[$i][6]) : "";
							$sex 				= !empty($sh[$i][7]) ? strtoupper($sh[$i][7]) : "";
							$dob 				= !empty($sh[$i][8]) ? trim($sh[$i][8]) : "";
							$note 				= !empty($sh[$i][9]) ? $sh[$i][9] : "";
							$share 				= !empty($sh[$i][10]) ? $sh[$i][10] : "";
							$address			= !empty($sh[$i][11]) ? $sh[$i][11] : "";
							
							$name 				= $fname .' '.$mname.' '.$lname;
							
							$name 	= trim($name);
							$status = '<span class="text-danger">FAILED</span>';
							
							if(strlen($name) > 0 && !empty($dob)){
								if($this->checkBirthdate($dob)){
									
									/* $user->refid = "000000";
									$user->role_id = 2; //member group id
									$user->username 	= substr($lname, 0, 4) . date('mdY', strtotime($dob));
									$user->password 	= date('mdY', strtotime($dob));
									$user->created  	= date('Y-m-d h:i:s');
									$user->firstname  	= $fname;
									$user->middlename  	= $mname;
									$user->lastname  	= $lname;
									$user->member_no  	= $emp_id;
									$user->status  		= "ACTIVE";
									$user->sex  		= $sex;
									$user->note  		= $note;
									$user->dob  		= date('Y-m-d', strtotime($dob));  */
									$code 				= strtolower($this->Common->generateString());
									
									
									$data_array[] = [
										'refid' 		=> "000000",
										'role_id' 		=> 2,
										'username' 		=> $emp_id,
										'password' 		=> $code,
										'contact_no'	=> $mobile,
										'created' 		=> date('Y-m-d h:i:s'),
										'firstname' 	=> $fname,
										'middlename' 	=> $mname,
										'lastname' 		=> $lname,
										'member_no' 	=> $emp_id,
										'status' 		=> "ACTIVE",
										'sex' 			=> $sex,
										'note' 			=> $note,
										'share' 		=> $share,
										'address' 		=> $address,
										'dob' 			=> date('Y-m-d', strtotime($dob)),
										'otp' 			=> $this->Common->generateOTP(),
										'otp_generated' => date('Y-m-d H:i:s'),
										'code' 			=> $code
									];
									
									$status = '<span class="text-success">SUCCESS</span>';
									
									/* if($user->getErrors()) {
											$error_msg = [];
											foreach( $user->getErrors() as $errors){
												if(is_array($errors)){
													foreach($errors as $error){
														$error_msg[]    =   $error;
													}
												}else{
													$error_msg[]    =   $errors;
												}	
											}

											if(!empty($error_msg)){			
												$err = $error_msg[0];
											}
											
										$this->Log(json_encode($user->getErrors()));
										$status = '<span class="text-danger text-uppercase">'.$err.'</span>';
									}else{
										$status = '<span class="text-success">SUCCESS</span>';
									} */
										
									/* if ($this->Users->save($user)) {
										$status = '<span class="text-success">SUCCESS</span>';
									}else{
										if($user->getErrors()) {
											$error_msg = [];
											foreach( $user->getErrors() as $errors){
												if(is_array($errors)){
													foreach($errors as $error){
														$error_msg[]    =   $error;
													}
												}else{
													$error_msg[]    =   $errors;
												}	
											}

											if(!empty($error_msg)){			
												$err = $error_msg[0];
											}
											
											$this->Log(json_encode($user->getErrors()));
											$status = '<span class="text-danger text-uppercase">'.$err.'</span>';
										}
											
									} */
									
								}else{
									$status = '<span class="text-danger text-uppercase">Invalid Birth Date</span>';
								}
								
								$_data .= '<tr>
									<td class="fs-9 bold text-default">'.$i.'</td>
									<td class="fs-9 bold text-success">'.$name.'</td>
									<td class="fs-9 bold text-default">'.$status.'</td>
								</tr>';
							}								
						} 
						
						
						if(!empty($data_array)){
								$users = $this->getTableLocator()->get('Users');
								$users = $users->newEntities($data_array);
								if ($this->Users->saveManyOrFail($users)){
									$respcode = 1;
									$msg = "Done";
								}else{
									$msg = "Saving all information failed, please try again.";
								} 
						}else{
							$msg = "Unable to process your request. All information were invalid";
						}
						
					
					}else{
						$msg = "You have uploaded an invalid file";
					}
				}
			}else{
				$msg = "Unable to read the file, please try again";
			}
			
		    //$this->log($this->getTheAuthor()."SUCCESSFULLY IMPORT A TOTAL PRODUCTS OF ".$_added." & TOTAL FAIL OF ".$_notadded, "_info");
			
			echo json_encode(array("respcode" => $respcode, "message" => $msg, "data" => $_data));	
			die();
		}
			
			
			//$groups = $this->Users->Roles->find('list', ['limit' => 200])->all();
			$this->set(compact('user'));
		
    }
	
	
	
	public function saveajax(){
			
			$this->isAdmin();
			$this->ajaxLayout();
			
			 $user = $this->Users->newEmptyEntity();
			 if ($this->request->is('ajax')) {
				
				$_user = $this->request->getData();
				$user = $this->Users->patchEntity($user, $this->request->getData());
				
				
				$user->refid = $refid;
				$user->added = date('Y-m-d H:i:s');
				//$user->modified = date('Y-m-d H:i:s');
				$user->status = 'ACTIVE';
				$refid = str_replace(" ", "", microtime() . $this->Common->generateRString());
				$user->refid = $refid;
				$user->role_id = 1;
				$user->disstaging_id = 1;
				$user->regCode = 1;
				$user->provCode = 1;
				$user->citymunCode = 1;
				$user->brgyCode = 1;
				$user->status = "ACTIVE";
				$user->added_by = $this->Auth->user('refid');
				
				$email 		= $_user['email'];
				$username 	= substr($_user["lastname"], 0, 4) . date('mdY', strtotime($_user["birthdate"]));
				$password 	= date('mdY', strtotime($_user["birthdate"]));
				
				/* $params = array(
					$_user['brgyCode'],
					$_user['citymunCode'],
					$_user['provCode'],
					$_user['regCode'],
				);
				
				$address = $_user['sitio'].' '.$this->generateAddress($params);
				$user->address = $address; */
				
				//$this->log(json_encode($this->request->getData()));
				//$this->log("BD".$_user["birthdate"]);
				
				if(!empty($_user["birthdate"]) && !empty($_user["lastname"])){
					$user->username = $username;
					$user->password = $password;
				}
				
				if(empty($_user['diststaging_id'])){
					$user->diststaging_id = 10;
				}
				
				$resp 	= 0;
				
				if ($this->Users->save($user)){
					$this->log($this->getTheAuthor()." CREATED NEW ACCOUNT ". $refid, "_info");
					$resp 	= 1;
					$msg = $this->Message->showMsg('save');
					//notify the user and send the code for later use
					//email the account
					if(!empty($email)){
						$this->sendaccount($email, $username, $password);
					}
					
				}else{
					//$this->log(json_encode($this->request->getData()));
					$err = '';
					if($user->getErrors()){
						//$this->log(json_encode($user->getErrors()));
						$error_msg = [];
						$this->log(json_encode($user->getErrors()));
						
						foreach( $user->getErrors() as $errors){
							if(is_array($errors)){
								foreach($errors as $error){
									$error_msg[]    =   $error;
								}
							}else{
								$error_msg[]    =   $errors;
							}
						}

						if(!empty($error_msg)){
							
							/*$this->Flash->error(
								__("Please fix the following error(s):".implode("\n \r", $error_msg))
							);*/
							
							$err = $error_msg[0];
						}
					}
					
					$msg = $this->Message->showMsg('save_failed').' '. $err;
				}
				echo json_encode(array('resp' => $resp, 'msg' => $msg));
			}
			$this->set(compact('user'));
	}
	
	
    public function edit($refid=null, $id=null, $type=null){
	
        $user = $this->Users->get($id, [
            'contain' => [],
        ]);
	
        $roles = $this->Users->Roles->find('list')->where(['id >' => 1])->all();
		$this->set(compact('user', 'roles'));
		$this->set('type', $type);
			
		
		if ($this->request->is(['put', 'post'])) {
					$this->ajaxLayout();
					$resp = 0;
					$data = $this->request->getData();
					$user = $this->Users->patchEntity($user, $this->request->getData());
					$error = $this->showError($user);
					
						if(!empty($error)){
							//$this->Log(json_encode($user->getErrors()));
							$msg = '<span class="text-danger">Save failed. '.$error.'</span>';
						}else{
							if ($this->Users->save($user)) {
								//$this->Flash->success('Member successfully registered.')
								//return $this->redirect(['action' => 'add']);
								$resp = 1;
								$msg = '<span class="text-success">Changes successfully saved</span>';
							}else{
								$msg = '<span class="text-danger">Save failed. Some information were missing or invalid.</span>';
							}
						}
		
					echo json_encode(array('resp' => $resp, 'msg' => $msg));
					die();
				
		}


    }

	private function resizeImage($resourceType, $image_width, $image_height, $resizeWidth, $resizeHeight){
		$imageLayer = imagecreatetruecolor($resizeWidth, $resizeHeight);
		imagecopyresampled($imageLayer, $resourceType, 0, 0, 0, 0, $resizeWidth, $resizeHeight, $image_width, $image_height);
		return $imageLayer;
	}	

	public function uploadavatar(){
		if($this->request->is('ajax')){
			
			$this->ajaxLayout();
			$respcode 		= 1;
			$_data 	  		= '';
			$msg			= '';
			$row 			= 1;
			$_added 		= 0;
			$_notadded 		= 0;
			$ndata			= array();
			$imgg			= '';
			
			if(isset($_FILES["defaultform"])){
				$error = $_FILES["defaultform"]["error"];						
				if($error){
					$msg = "You have uploaded an invalid file";
				}else{
					if(!is_array($_FILES["defaultform"]["name"])){
							

							$refid				= $_POST['refid'];
							
							$fileName 			= $_FILES["defaultform"];	
							$extension 			= pathinfo($fileName['name'], PATHINFO_EXTENSION);
							$new_file_name   	= $refid . date('YmdHis');
							$sourceProperties 	= getimagesize($fileName['tmp_name']);				
							$uploadImageType 	= $sourceProperties[2];
							$sourceImageWidth 	= $sourceProperties[0];
							$sourceImageHeight 	= $sourceProperties[1];
							$new_width			= intval($sourceImageWidth * 0.2);
							$new_height			= intval($sourceImageHeight * 0.2);
							$resizeFileName 	= time();
							$new_file 			= $this->imagedir('local', 1) . $new_file_name.'.'.$extension;

							switch ($uploadImageType){
								case IMAGETYPE_JPEG:
									$resourceType = imagecreatefromjpeg($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagejpeg($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break;

								case IMAGETYPE_GIF:
									$resourceType = imagecreatefromgif($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagegif($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break; 

								case IMAGETYPE_PNG:
									$resourceType = imagecreatefrompng($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagepng($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break;

								case IMAGETYPE_JPG:
									$resourceType = imagecreatefrompng($fileName['tmp_name']);
									$imageLayer = $this->resizeImage($resourceType, $sourceImageWidth, $sourceImageHeight, $new_width, $new_height);
									imagepng($imageLayer, $new_file);
									imagedestroy($imageLayer);
								break;
								default:
									$respcode = 0;
								break;
							}
						
						
						if($respcode==1){
							$imgg 						= $this->imagedir('url') . date('Y').'/'.date('m').'/'.$new_file_name.'.'.$extension;
							$image_to_save 		= $this->imagedir('url') . date('Y').'/'.date('m').'/'.$new_file_name.'.webp';
							//update image
							$user = $this->Users->find()
							->select(['id', 'refid', 'avatar'])							
							->where(['refid' => $refid])
							->contain([])
							->first();
							
							if(!empty($user)){							    
							
								$dir 				= $this->imagedir('local', 1); 
								$imagine = new \Imagine\Gd\Imagine();
								$_image = $imagine->open($imgg);
								$_image->save($dir . $new_file_name.'.webp', array('webp_quality' => 50)); 
						
						
								 $user->avatar = $image_to_save;
								 $this->Users->save($user);
							}
							
							$msg 		= "Image upload done!";
						}else{
							$msg 		= "Image upload failed";
						}							
						
					}else{
						$msg = "You have uploaded an invalid file";
					}
				}
			}else{
				$msg = "Unable to read the file, please try again";
			}
			
		   echo json_encode(array("respcode" => $respcode, "message" => $msg, "data" => $_data, "img" => $imgg));	
			die();
		}
	}
	
	
	
	public function cropimage(){
		$this->ajaxLayout();
		
		if($this->request->is('ajax')){
			$data = $this->request->getData();
			
			$img 	= $data['image'];
			$userid = $data['userid'];
			$refid 	= $data['refid'];
			$w 		= intval($data['rw']);
			$h 		= intval($data['rh']);
			$x 		= intval($data['rx']);
			$y 		= intval($data['ry']);
			
			//extract the url
			$main_url 	= $img;
			$url 		= parse_url($main_url, PHP_URL_SCHEME).'://'.parse_url($main_url, PHP_URL_HOST); 
			$base_url 	= trim($url, '/');
			$dir 		= dirname(__FILE__, 6)."/scimpc"; //live dir
			//$dir 		= dirname(__FILE__, 6);
			$img		= str_replace($url, $dir, $main_url);
			
			$basename 	= basename($img);
			$extension 	= pathinfo($basename, PATHINFO_EXTENSION);
		
			
			switch($extension){
				case "PNG":
				case "png":
					$img_r = imagecreatefrompng($img);
				break;
				case "JPEG":
				case "jpeg":
				case "jpg":
				case "JPG":
					$img_r = imagecreatefromjpeg($img);
				break;
				default:
					$img_r = imagecreatefromjpeg($img);
				break;
			}
			
			
			$dst_r = imagecreatetruecolor($w, $h);

			imagecopyresampled($dst_r, $img_r, 0, 0, $x, $y, $w, $h, $w, $h);
			//$new_file = $this->imagedir('local') .date('Y').'/'.date('m').'/'.$userid.'-'.$refid.'.'.$extension;
			//$return_file = $this->imagedir('url')  . date('Y').'/'.date('m').'/'.$userid.'-'.$refid.'.'.$extension;
			$new_file = $this->imagedir('local') .date('Y').'/'.date('m').'/'.$userid.'-'.$refid.'-'.date('YmdHis').'.'.$extension;
			$return_file = $this->imagedir('url')  . date('Y').'/'.date('m').'/'.$userid.'-'.$refid.'-'.date('YmdHis').'.'.$extension;
			
			
			switch($extension){
				case "PNG":
				case "png":
					imagepng($dst_r, $new_file, 100);
				break;
				case "JPEG":
				case "jpeg":
				case "jpg":
				case "JPG":
					imagejpeg($dst_r, $new_file, 100);
				break;
				default:
					imagejpeg($dst_r, $new_file, 100);
				break;
			}
			
			
			$user = $this->Users->get($userid, [
					'contain' => [],
			]);
								
			$user = $this->Users->patchEntity($user, $this->request->getData());
			$user->avatar = $return_file;	
			$this->Users->save($user);
			
			echo json_encode(array("img" => $return_file));
			
			imagedestroy($img_r);
			exit;
		}
	}

	public function avatar($refid=null, $id=null){
		//$id 	= $this->request->getParam('id');
		//$refid 	= $this->request->getParam('refid');
		
        $user = $this->Users->get($id, [
            'contain' => [],
        ]);
		
/* 
        if ($this->request->is(['post'])) {
			$data = $this->request->getData();
            $user = $this->Users->patchEntity($user, $data);
			$user->avatar = $data['avatar'];
			
            if ($this->Users->save($user)) {
                $this->Flash->success(__('Avatar has been saved!'));
               
            }else{
				$this->Flash->error(__('The user could not be saved. Please, try again.'));
			}
			
			 return $this->redirect(['action' => 'users-masterlist']);
        } */
		
        $this->set(compact('user'));
    }
	
	public function userhistory($refid=null, $id=null){
		$user = $this->Users->get($id, ['contain' => ['Votecounts' => ['Elections']]]);
		$this->set('user', $user);
	}
	
	
	
	public function resetaccount(){
		$this->ajaxLayout();
		if($this->request->is('ajax')){
			$refid = $this->request->getParam("refid");
			$user_id = $this->request->getParam("user_id");
			$reset_type = $this->request->getParam("reset_type");
			
			$user = $this->Users->find()
			->where(['refid' => $refid, 'id' => $user_id])
			->contain([])
			->first();
			
			$success = false;
			if(!empty($user)){			
				switch($reset_type){
					case "reset_password":
						$new_password = strtolower($this->Common->generateString());
						$user->password = $new_password;
						if($this->Users->save($user)){
							$success = true;
							$msg = "Password has been reset. Please take note of the new password -- " .$new_password;
						}else{
							$msg = "Password reset failed, please try again.";
						}
					break;
					case "reset_otp":
						$new_otp 	= $this->Common->generateOTP();
						$user->otp 	= $new_otp;
						$user->otp_generated = date('Y-m-d H:i:s');
						if($this->Users->save($user)){
							$success = true;
							$msg = "OTP has been reset. Please take note of the new otp -- " .$new_otp;
						}else{
							$msg = "OTP reset failed, please try again.";
						}
					break;
					/* case "reset_qr":
						$url = $this->qrweburl();
						require_once(ROOT . DS . 'vendor' . DS . "phpqrcode" . DS . "qrlib.php");
						
						$url = $url .$u->username.'/'.$u->code.'/'.$u->refid.'/'.$u->id.'/'.$u->lastname.'/'.$election->id;
						$id 	= str_pad($u->id, 6, "0", STR_PAD_LEFT);
						$filename = $id."_file.png";
						$pngAbsoluteFilePath = $dir.$filename;
						QRcode::png($url, $pngAbsoluteFilePath, QR_ECLEVEL_L, 4);
						
						$success = true;
						$msg = "Election QR Code has been Generated";

					break; */
					case "send_otp":
						$new_otp 	= $this->Common->generateOTP();
						$user->otp 	= $new_otp;
						$user->otp_generated = date('Y-m-d H:i:s');
						if($this->Users->save($user)){
							
							if(!empty($user->contact_no)){
								//send the otp the number
							}
							$success = true;
							$msg = "OTP has been reset & sent. Please take note of the new otp -- " .$new_otp;
						}else{
							$msg = "OTP reset failed, please try again.";
						}
					break;
					default:
					break;
				}
			}else{
				$msg = "Account not found, please try again";
			}
			
		}
		
		if($success){
			$msg = '<span class="text-success">'.$msg.'</span>';
		}else{
			$msg = '<span class="text-danger">'.$msg.'</span>';
		}
		
		echo json_encode(array("message" => $msg));
		exit();
	}
	
}
