<?php
declare(strict_types=1);

/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Controller\Controller;

/**
 * Application Controller
 *
 * Add your application-wide methods in the class below, your controllers
 * will inherit them.
 *
 * @link https://book.cakephp.org/4/en/controllers.html#the-app-controller
 */
class AppController extends Controller
{
    /**
     * Initialization hook method.
     *
     * Use this method to add common initialization code like loading components.
     *
     * e.g. `$this->loadComponent('FormProtection');`
     *
     * @return void
     */
    public function initialize(): void{
        parent::initialize();

        $this->loadComponent('RequestHandler');
        $this->loadComponent('Flash');
       // $this->loadComponent('Auth');
		$this->loadComponent('Authentication.Authentication');
		//$this->loadComponent('Authorization.Authorization');
		$this->loadComponent('Authorization.Authorization', [
			'skipAuthorization' => [
				'login', 'logout', 'unauthorized'
			]
		]);

        /*
         * Enable the following component for recommended CakePHP form protection settings.
         * see https://book.cakephp.org/4/en/controllers/components/form-protection.html
         */
        
		$this->loadComponent('FormProtection');
		$this->loadComponent('Common');
    }
	
	/* public function isAuthorized($user){
		if(isset($user['role_id']) && $user['role_id'] === 2){
			return true;
		}
		
		return false;
	} */
	
	 public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->FormProtection->setConfig(
		'unlockedActions',[
			'uploadfiles', 
			'saveavatar', 
			'login',
			'upload', 
			'indexajax', 
			'uploadavatar', 
			'cropimage', 
			'castvote', 
			'saveedit', 
			'add', 
			"checkvote", 
			"index", 
			"checkStocks", 
			"indexstocks",
			"edit",
			"selectmember"
		]);
		
		
		/* $identity = $this->request->getAttribute('identity');
		if(!empty($identity)){
			if($identity->getGroup()==1){ //administrator
				$this->viewBuilder()->setTheme('Celestial');
				debug($this->request->getParam('prefix'));
			}else{
				
				
			}
		} */
		
		$auth = $this->request->getSession()->read('Auth');
		
		if(isset($auth)){
			
			$this->viewBuilder()->setTheme('Celestial');
			$prefix = $this->request->getParam('prefix');
			$action = $this->request->getParam('action');
			
			$identity = $this->request->getAttribute('identity');
			if(!empty($identity)){
				if(in_array($action, array("login", "validateotp", "logout", "cropimage", "uploadavatar", "validateotpadmin"))){
					return true;
				}else{
					$group = $identity->getGroup();
					$user = $this->getCurrentUser();
					$id 	= $user['id'];
					switch($group){
						case 1:
							if($prefix=="Admin"){
								if($this->checkUserOTP($id)){
									return true;
								}else{
									$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
									return $this->redirect($target);
								}
								
							}else{
								$this->Flash->error(__('You are not authorized to access the page. Please login again.'));
								return $this->redirect(['controller' => 'users', 'action' => 'logout']);							 
							}						
						break;
						default:
							if($prefix=="Member"){
								if($this->checkUserOTP($id)){
									return true;
								}else{
									$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
									return $this->redirect($target);
								}
							}else{
								$this->Flash->error(__('You are not authorized to access the page. Please login again.'));
								return $this->redirect(['controller' => 'users', 'action' => 'logout']);							 
							}	
						break;
					}
				}
			}
		}
    }
	
	public function checkUserOTP($id=null){
		//$this->loadModel('Users');
		$userTable = $this->getTableLocator()->get('Users');
		
		$otp = $userTable->find()
		->select(['otp_status', 'last_login', 'last_logout', 'skey'])
		->where(['id' => $id])
		->contain([])
		->first();
		
		$current = date("Y-m-d H:i:s");
		
		$session = $this->getRequest()->getSession(); 		
		$skey = $session->read('Config.session_key');
		
		//Config.session_key
		
		if(!empty($otp)){			
			if($otp->otp_status == 1){		
				//if($otp->last_login > $otp->last_logout){
					if($skey == $otp->skey){
						return true;
					}
				//}
			}
		}
		
		return false;
	}	
	
	
	public function ajaxLayout(){
		$this->viewBuilder()->setLayout('ajax');
		$this->autoRender = false;
		$this->view = false;
	}
	
	public function imageLayout(){
		$this->viewBuilder()->setLayout('image');
		$this->autoRender = false;
		$this->view = false;
	}
	
	public function disableView(){
		if($this->request->is('ajax')){
			return true;
		}else{
			$this->autoRender = false;
			$this->view = false;
		}
	}
	
	public function showError($model){
		$err = '';
		if($model->getErrors()) {
			$this->Log(json_encode($model->getErrors()));
			$error_msg = [];
			foreach( $model->getErrors() as $errors){
			if(is_array($errors)){
				foreach($errors as $error){
					$error_msg[]    =   $error;
				}
			}else{
				$error_msg[]    =   $errors;
				}	
			}

			if(!empty($error_msg)){			
				$err = $error_msg[0];
			}
		}
		
		return $err;
	}
	
	private function checkFolder(){

		//$dir 		= dirname(__FILE__, 5); //directory level
		//$dir 		= $dir ."/ppsta/ppsta/site_images/Uploads";
		$dir		= $_SERVER['DOCUMENT_ROOT'].'/ppsta/ppsta/site_images/Uploads';
		$year 		= date('Y');
		$month 		= date('m');
		$day 		= date('d');
		
	/* 	 if(is_dir($dir) && is_writeable($dir)){
			return true;
		 }else{
			return false;
		 } */
			
			if(is_dir($dir.'/'.$year) && is_writeable($dir.'/'.$year)){	
				if(is_dir($dir.'/'.$year.'/'.$month) && is_writeable($dir.'/'.$year.'/'.$month)){		
					if(is_dir($dir.'/'.$year.'/'.$month.'/'.$day) && is_writeable($dir.'/'.$year.'/'.$month.'/'.$day)){		
						return true;
					}else{
						if(mkdir($dir.'/'.$year.'/'.$month.'/'.$day, 0777)){
							return true;
						}else{
							return false;
						}
					}
				}else{
					if(mkdir($dir.'/'.$year.'/'.$month, 0777)){
						return true;
					}else{
						return false;
					}
				}
			}else{
				if(mkdir($dir.'/'.$year, 0777)){
					if(is_dir($dir.'/'.$year.'/'.$month) && is_writeable($dir.'/'.$year.'/'.$month)){		
						if(is_dir($dir.'/'.$year.'/'.$month.'/'.$day) && is_writeable($dir.'/'.$year.'/'.$month.'/'.$day)){		
							return true;
						}else{
							if(mkdir($dir.'/'.$year.'/'.$month.'/'.$day, 0777)){
								return true;
							}else{
								return false;
							}
						}
					}else{
						if(mkdir($dir.'/'.$year.'/'.$month, 0777)){
							return true;
						}else{
							return false;
						}
					}
				}else{
					return false;
				}
			}
	}
		
	
	public function uploadImageFile($filename, $newfilename, $extension){
			//$dir 			= WWW_ROOT . 'img/Uploads/'.date('Y').'/'.date('m').'/';
			//$dir 		= dirname(__FILE__, 5); //directory level
			//$dir 		= $dir .'/ppsta/ppsta/site_images/Uploads/'.date('Y').'/'.date('m').'/';
			$dir 			= $_SERVER['DOCUMENT_ROOT'].'/ppsta/ppsta/site_images/Uploads/'.date('Y').'/'.date('m').'/';
			$upload_dir  	= $dir . basename($filename['name']);	
			
			
			if($this->checkFolder()){
				if(move_uploaded_file($filename['tmp_name'], $upload_dir)){
					$file_handler = fopen($upload_dir, 'r');	
					fclose($file_handler);
					if(!empty($newfilename)){
						if(rename($upload_dir, $dir.''.$newfilename.'.'.$extension)){			
							return true;
						}else{
							return false;
						}
					}else{
						return true;
					}				
				}else{
					return false;
				}
			}
	}
	
	public function qrweburl(){
		//return "http://localhost/ppsta/users/loginqwithqrcode/"; 
		return "http://localhost/SEMPCO/members/users/loginwithqrcode/";
	}
	
	public function imagedir($type=null, $create=null){
		switch($type){
			case "local":
				if(isset($create) && !empty($create)){
					if($this->checkFolder()){
						$dir = $_SERVER['DOCUMENT_ROOT'].'/SEMPCO/site_images/Uploads/'.date('Y').'/'.date('m').'/'.date('d').'/';
					}else{
						$this->Log("Error in creating image folder");
						$dir = $_SERVER['DOCUMENT_ROOT'].'/SEMPCO/site_images/Uploads/';
					}
				}else{
					$dir = $_SERVER['DOCUMENT_ROOT'].'/SEMPCO/site_images/Uploads/';
				}
			break;
			case "url":
				$dir = "http://localhost/SEMPCO/site_images/Uploads/";
			break;
			default:
				$dir = $_SERVER['DOCUMENT_ROOT'].'/SEMPCO/site_images/Uploads/';
			break;
		}
		
		return $dir;
	}
	
	public function qrcodedir($type=null){
		switch($type){
			case "local":
				$dir = $_SERVER['DOCUMENT_ROOT'].'/ppsta/ppsta/site_images/Qrcode/';
			break;
			case "url":
				$dir = "http://localhost/ppsta/ppsta/site_images/Qrcode/";
			break;
			default:
				$dir = $_SERVER['DOCUMENT_ROOT'].'/ppsta/ppsta/site_images/Qrcode/';
			break;
		}
		
		return $dir;
	}	
	
	public function getCurrentUser(){
		return $this->request->getSession()->read('Auth');
	}
	
	public function generatePassword(){
		
	}
	
	public function generateOTP(){
	
	}
	

	
	public function generateRefid(){
		
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < 6; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		
        $refid = microtime(true) . $str;
		return $refid;
	}
	
	public function getSettings(){
		$settings = $this->getTableLocator()->get('Settings');
		$setting  = $settings->get(1, ['contain' => []]);			
		return $setting;
	}
	
	public function loadSettings(){
		$settingTable = $this->getTableLocator()->get('Settings');
		//$this->loadModel('Settings');
		
		$settings = $settingTable->find()				
		->contain([])
		->first();			
		
		return $settings;
	}	
	
	public function getTheAuthor(){
		$user	= $this->getCurrentUser();
		$id 	= $user['id'];
		return $id;
	}
	
	/*-------------------------
	| Places
	------------------------*/
	public function getRegionList(){
	//	$this->loadModel('Regions');
		$regionTable = $this->getTableLocator()->get('Regions');
		$data = $regionTable->find()
		->select(['id', 'regDesc'])
		->order(['id' => 'ASC']);


		$data = $data->all();
		$_data = array();

		$lists = array();
		if(!empty($data)){
			foreach($data as $c):
			$lists[$c->id] =  strtoupper($c->regDesc);
			endforeach;
		}
		return $lists;
	}
	
	public function getProvinceList($reg=null){
		$provinceTable = $this->getTableLocator()->get('Provinces');
		
				$data = $provinceTable->find()
					->select(['provCode', 'provDesc'])
					->where(['regCode' => $reg]);
					
					
				$data = $data->all();	
				$_data = array();

				$lists = array();
				if(!empty($data)){
					foreach($data as $c):
						$lists[$c->provCode] =  strtoupper($c->provDesc);
					endforeach;
				}
				return $lists;
	}
	
	public function getCityList($reg=null, $prov=null){
		$cityTable = $this->getTableLocator()->get('Cities');
		
				$data = $cityTable->find()
					->select(['citymunCode', 'citymunDesc'])
					->where(['regDesc' => $reg, 'provCode' => $prov]);
					
					
				$data = $data->all();	
				$_data = array();

				$lists = array();
				if(!empty($data)){
					foreach($data as $c):
						$lists[$c->citymunCode] =  strtoupper($c->citymunDesc);
					endforeach;
				}
				return $lists;
	}
	
	public function getBarangayList($reg=null, $prov=null, $cty=null){
		$barangayTable = $this->getTableLocator()->get('Barangays');
				
				$data = $barangayTable->find()
					->select(['brgyCode', 'brgyDesc'])
					->where(['regCode' => $reg, 'provCode' => $prov, 'citymunCode' => $cty]);
					
					
				$data = $data->all();	
				$_data = array();

				$lists = array();
				if(!empty($data)){
					foreach($data as $c):
						$lists[$c->brgyCode] = strtoupper($c->brgyDesc);
					endforeach;
				}
				return $lists;
	}
   
   

	
	
}
