<?php

namespace App\Controller\Component;

use Cake\Controller\Component;

class CommonComponent extends Component
{
    
	public function imageDIR($type=null){
		switch($type){
			case "display":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']).'/product_images/';
			break;
			case "web":
				$dir = "http://localhost/DEPED/product_images/";
			break;
			case "received":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']).'/DEPED/product_images/Received';
			break;
			case "inspection":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']).'/DEPED/product_images/Inspection';
			break;
			case "acceptance":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']).'/DEPED/product_images/Acceptance';
			break;
			default:
				$dir = dirname($_SERVER['DOCUMENT_ROOT']).'/DEPED/product_images/Uploads';
			break;
		}
		return $dir;
	}
	
	public function imagePublicUrl(){
		return 'http://localhost/JAMC_MARKETING/product_images/';
	}
	
	
	public function generateString($len=null){
		$str = "";
		$len = !empty($len) ? $len : 6;
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $len; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		
	    return strtoupper($str);
	}
	
	
	public function generateOTP(){
		$str = "";
		$characters = array_merge(range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < 6; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		
	    return strtoupper($str);
	}
	
	public function formatSeries($no){
		return str_pad($no, 8, "0", STR_PAD_LEFT);
	}
	
	public function splitName($name) {
		$name = trim($name);
		$last_name = (strpos($name, ' ') === false) ? '' : preg_replace('#.*\s([\w-]*)$#', '$1', $name);
		$first_name = trim( preg_replace('#'.preg_quote($last_name,'#').'#', '', $name ) );
		return array($first_name, $last_name);
	}
	
	public function validateDate($date){
		
		$date = str_replace("/", "", $date);
		$mo = substr($date, 0, 2);
		$dy = substr($date, 2, 2);
		$yr = substr($date, 4, 4);
				
		if($mo <= 12){
			if($dy <= 31){
				if($yr <= date("Y")){
					return true;
				}else{
					return false;
				}
			}else{
				return false;
			}
		}else{
			return false;
		}
	}
	
	public function civilStatus(){
		$options = [
			'SINGLE' 	=> 'SINGLE',
			'MARRIED' 	=> 'MARRIED',
			'SEPARATED' => 'SEPARATED',
			'DIROVCED' 	=> 'DIROVCED',
			'WIDOWED' 	=> 'WIDOWED'
		];
		
		return $options;
	}
	
	public function payMent(){
		$options = [
			'RPSU' 			=> 'REGIONAL PAYROLL SYSTEM UNIT',
			'DIRECT' 		=> 'DIRECT',
			'LOCAL' 		=> 'LOCAL (H.SCHOOL/COLLEGE/UNIVERSITY)',
			'EXEMPTED' 		=> 'EXEMPTED',
			'IBM REGIONAL' 	=> 'IBM REGIONAL',
			'IBM NATIONAL' 	=> 'IBM NATIONAL',
			'EMPLOYEE' 		=> 'EMPLOYEE'
		];
		
		return $options;
	}
	
	public function payMentMode(){
		$options = [
			'MONTHLY' 		=> 'MONTHLY',
			'QUARTERLY' 	=> 'QUARTERLY',
			'SEMI-ANNUAL'	=> 'SEMI-ANNUAL',
			'ANNUAL' 		=> 'ANNUAL',			
		];
		
		return $options;
	}
	
	public function docuMents($sel=null){
		$options = [
			'1' => 'Permanent Appointment or Latest Service Record',			
			'2' => 'Latest Payslip',			
			'3' => 'Photo Copy or 2 Valid ID',			
			'4' => 'Personal Health Declaration',			
			'5' => 'Verifiers Approval (DepEd Approval)',			
			'6' => 'Authority to deduct (APDS)',			
			'7' => 'Selfie Photo Holding digitally signed accomplished application (for online registation only)',			
			'8' => 'Recent ID Picture'
		];
		
		if(isset($sel) && !empty($sel)){
			$options = $options[$sel];
		}
		
		return $options;
	}
	
	public function Accountstatus(){
		$data = [
			'ACTIVE' => 'ACTIVE',
			'INACTIVE' => 'INACTIVE',
			'LEAVE' => 'LEAVE',
		];

		// Convert all keys and values to uppercase
		$data = array_map(function ($value) {
			return strtoupper($value);
		}, array_change_key_case($data, CASE_UPPER));

		
		return $data;
	}
	
	
	public function subOffices(){
		$data = [
			'ARAS-ASAN' => 'ARAS-ASAN',
			'MADRID' => 'MADRID',
			'SAN MIGUEL' => 'SAN MIGUEL',
			'TANDAG' => 'TANDAG',
		];

		// Convert all keys and values to uppercase
		$data = array_map(function ($value) {
			return strtoupper($value);
		}, array_change_key_case($data, CASE_UPPER));

		
		return $data;
	}
	
	public function Positions(){
		$positions = [
			'HRMANAGER' => 'Human Resources Manager',
			'PROJECTMANAGER' => 'Project Manager',
			'ENGINEER' => 'Electrical Engineer',
			'TECHNICIAN' => 'Field Technician',
			'SALESMANAGER' => 'Sales Manager',
			'CUSTOMERSERVICEREP' => 'Customer Service Representative',
			'LINEMAN' => 'Electrical Lineman'
		];

		// Convert all keys and values to uppercase
		$positions = array_map(function ($value) {
			return strtoupper($value);
		}, array_change_key_case($positions, CASE_UPPER));

		
		return $positions;

	}
	
	
	
	
}