<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Users Controller
 *
 * @property \App\Model\Table\UsersTable $Users
 * @method \App\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UsersController extends AppController
{
   
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		
		$this->Authentication->allowUnauthenticated(['login', 'updateAdmin', 'createadmin',  'unauthorized', 'qrcodefinder', 'loginwithqrcode']);
	}

	
	public function updateAdmin(){
		  $user = $this->Users->get(1, [
            'contain' => [],
        ]);
	

					$this->ajaxLayout();
					$resp = 0;
					
					$user = $this->Users->patchEntity($user,  ['validation' => false]);
					
		$user->password = "admin";
		if($this->Users->save($user)){
			echo "saved";
		}else{
			echo "failed";
		}
		
		exit();
		
	}
	
/* 	public function createadmin(){
		$this->Authorization->skipAuthorization();
		$this->ajaxLayout();
		$user = $this->Users->newEmptyEntity();
		$user->role_id = 1;		
		$user->username = "admin";
		$user->refid = "123123123";
		$user->password = "admin";
		$user->contact_no = "09054122663";
		$user->name = "POS ADMINISTRATOR";		
		$user->status = "ACTIVE";
		$user->created = date("Y-m-d H:i:s");
		
		//$user = $this->Users->patchEntity($user, ['validation' => false]);
		if ($this->Users->save($user)) {
			echo "Saved";
		}
	}    */
	
	

	public function validateotpadmin(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$user	= $this->getCurrentUser();
		$id 	= $user['id'];
		
		if ($this->request->is('post')) {
			$data = $this->request->getData();
			$otp  = $data['otp'];
			$user = $this->Users->find()
			->select(['id', 'otp_status'])
			->where(['id' => $id, 'otp' => $otp])
			->first();
			
			if(!empty($user)){
				$user->otp_status = 1;
				if($this->Users->save($user)){
					$this->updateLogin("login", $user->id);
					$target = $this->Authentication->getLoginRedirect() ?? '/admin/settings/system-statistics';
					return $this->redirect($target);
				}
				
			}
			
			//lock the user in many attempts
			$this->Flash->error('You have provided an invalid OTP. Please try again');
		}
		
	}
	
	public function unauthorized(){
		
	}
	
	private function updateLogin($type = null, $userid=null){
		
		if(isset($userid) && !empty($userid)){
			$user = $this->Users->get($userid);
			
			if($type=="login"){			
				$user->last_login = date('Y-m-d H:i:s');
				$user->login_status = "ONLINE";
				$user->ip_address = $_SERVER['REMOTE_ADDR'];
			}else{
				$user->last_logout = date('Y-m-d H:i:s');
				$user->login_status = "OFFLINE";
				//$user->otp = $this->Common->generateOTP();
				$user->otp_status = 0;
			}
			
			$this->Users->save($user);
		}
	}
	
	private function generateNewOTP($userid){
		$user = $this->Users->get($userid);
		$user->otp = "118899"; //$this->Common->generateOTP();
		$user->otp_generated = date("Y-m-d H:i:s");
		$user->otp_status = 0;
		$this->Users->save($user);		
	}
	
	private function setTheKey(){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < 6; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		
        $refid = microtime(true) . $str;
		return $refid;
	}
	
	private function generatetimelog($id=null, $rate=null, $key=null){
		
		$session = $this->getRequest()->getSession(); 
		
		$session->write([
			'Config.theme' => 'blue',
			'Config.language' => 'en',
			'Config.session_key' => $key
		]);
		
		$userlogin = $this->Users->Userlogins->newEmptyEntity();      
        $userlogin = $this->Users->Userlogins->patchEntity($userlogin, ['validation' => false]);
		$userlogin->user_id = $id;
		$userlogin->login = date("Y-m-d H:i:s");
		$userlogin->skey = $key;
		$userlogin->rate = $rate;
        $this->Users->Userlogins->save($userlogin);
		
	}
	
	private function computeTimeLog(){
		
	}
	
	
	public function validateotp(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$uuser	= $this->getCurrentUser();
		$id 	= $uuser['id'];
		
		$_user = $this->Users->newEmptyEntity();
		$this->set('_user', $_user);
		$this->set('user', $uuser);
		
		$status = 0;
		$role = $uuser['role_id'];
		$target = 0;
		$msg = "";
		
		if ($this->request->is('post')) {
			$data = $this->request->getData();
			//$this->log("OTP data"  . json_encode($data));
			$otp  = $data['otp'];
			$user = $this->Users->find()
			->select(['id', 'otp_status'])
			->where(['id' => $id, 'otp' => $otp])
			->first();
			
			if(!empty($user)){
				$key = $this->setTheKey();
				$user->otp_status = 1;
				$user->skey = $key;
				
				if($this->Users->save($user)){					
					$this->updateLogin("login", $user->id);
					$this->generatetimelog($user->id, $user->rate, $key);
					$status = 1;
					$target = $this->Authentication->getLoginRedirect() ?? '/admin/settings/system-statistics';
				}
			}else{
				$msg = "You have provided an invalid OTP check the details and then try again";
			}
			
			
			if($this->request->is('ajax')){
				$this->ajaxLayout();
				$resp = [
					'target' => $target,
					'role' => $role,
					'status' => $status,
					'message' => $msg
				];
					
				echo json_encode($resp);
				exit();
			}else{
				return $this->redirect($target);
			}
			
			//lock the user in many attempts
			//$this->Flash->error('You have provided an invalid OTP. Please try again');
		}
		
		
		
	}
	
	
	public function login(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$user = $this->Users->newEmptyEntity();
		$this->set('user', $user);
			
		
		if($this->request->is('post')){
			
			//$data = $this->request->getData();
			//$this->log(json_encode($data));
			$result = $this->Authentication->getResult();
			$status = 0;
			$role = 0;
			$target = 0;
			
			if ($result->isValid()) {
				// If the user is logged in send them away.
				//
				$user = $result->getData();
				//check member status
				if($user->status=="ACTIVE"){
					$this->updateLogin("logout", $user->id);
					
					$this->generateNewOTP($user->id);
					$role = $user->role_id;
					$status = 1;
					$msg = "Account successfully authenticated, please click Proceed to continue";
					$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
					
				}else{
					$msg = "Your account needs to be activated. Please check your email for the activation link";
					
				}
					
			}else{
				$msg ="Login failed. You have provided an invalid credentials.";
			}
			
			if($this->request->is('ajax')){
				$resp = [
					'target' => $target,
					'role' => $role,
					'status' => $status,
					'message' => $msg
				];
				
				echo json_encode($resp);
				exit();
			}else{
				return $this->redirect($target);
			}
		} 
		
		
	}
	

	
	public function loginwithqrcode($username=null, $code=null, $refid=null, $id=null, $lastname=null){
/* 		$username 	= $this->request->getParam('username');
		$code 		= $this->request->getParam('code');
		$refid 		= $this->request->getParam('refid');
		$id 		= $this->request->getParam('id');
		$lastname 	= $this->request->getParam('lastname');
						 */
		$this->Authorization->skipAuthorization();
		
		$user = $this->Users->find()
		->where([
			'username' 	=> $username,
			'code'	 	=> $code,
			'refid'		=> $refid,
			'id'		=> $id,
			//'lastname' 	=> $lastname 
		])
		->contain([])
		->first();
		
		
		if(!empty($user)){
			//check member status
			if($user->status=="ACTIVE"){
				
				
				/* $this->Flash->error('You have provided an invalid credentialssss.');
				$this->Authentication->logout();
				return $this->redirect(['controller' => 'Users', 'action' => 'login']); */
				
				$this->Authentication->setIdentity($user);
				//$target = $this->Authentication->getLoginRedirect() ?? '/member/elections/index';
				$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
			}else{
				$this->Flash->error('Your account is temporary deactivated');
				$target = $this->Authentication->getLoginRedirect() ?? '/users/logout';
			}
				return $this->redirect($target);
			
		}else{
			$this->Authentication->logout();
			return $this->redirect(['controller' => 'Users', 'action' => 'login']);
		}
			
		
	}
	
	
	public function logout(){
		//$this->Authorization->skipAuthorization();
		//$this->updateLogin("logout");
		$result = $this->Authentication->getResult();
		$user = $result->getData();
		$this->updateLogin("logout", $user->id);
		
		$this->Authentication->logout();
		return $this->redirect(['controller' => 'Users', 'action' => 'login']);
	}
	
	/* public function register(){
		$this->Authorization->skipAuthorization();
		$user = $this->Users->newEmptyEntity();
        if ($this->request->is('post')) {
			$data = $this->request->getData();
            $user = $this->Users->patchEntity($user, $data);
			
				$user->refid = "000000";
				$user->role_id = 1; //member group id
				
				if(isset($data['dob']) && !empty($data['dob'])){
					$user->username = substr($data['lastname'], 0, 4) . date('mdY', strtotime($data['dob']));
					$user->password = date('mdY', strtotime($data['dob']));
					$user->created  = date('Y-m-d h:i:s');
						
					
					if ($this->Users->save($user)) {
						$this->Flash->success(__('The user has been saved.'));
						return $this->redirect(['action' => 'index']);
					}
					
				}
			
            $this->Flash->error(__('The user could not be saved. Please, try again.' . $this->showError($user)));
        }
        $groups = $this->Users->Roles->find('list', ['limit' => 200])->all();
        $this->set(compact('user', 'groups'));
	} */
   
}
