<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Transaction Entity
 *
 * @property int $id
 * @property int $stock_id
 * @property int|null $customer
 * @property \Cake\I18n\FrozenTime $created
 * @property int $created_by
 * @property string $type
 * @property string $count
 *
 * @property \App\Model\Entity\Stock $stock
 */
class Transaction extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'stock_id' => true,
        'customer' => true,
        'created' => true,
        'created_by' => true,
        'type' => true,
        'count' => true,
        'stock' => true,
        'sale' => true,
        'selling_price' => true,
        'discount' => true,
        'rqty' => true,
        'qty' => true,
        'afqty' => true,
        'total_amount' => true,
    ];
	
	public function __construct() {
        $this->_accessible = array_change_key_case($this->_accessible, CASE_LOWER);
    }
	
}
