<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Transactionlog Entity
 *
 * @property int $id
 * @property string|null $RowId
 * @property string|null $TransactionDate
 * @property string|null $UserId
 * @property string|null $TableName
 * @property string|null $TransName
 * @property string|null $DeviceName
 * @property string|null $Description
 * @property string|null $Reference1
 * @property string|null $Reference2
 * @property string|null $Reference3
 */
class Transactionlog extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'RowId' => true,
        'TransactionDate' => true,
        'UserId' => true,
        'TableName' => true,
        'TransName' => true,
        'DeviceName' => true,
        'Description' => true,
        'Reference1' => true,
        'Reference2' => true,
        'Reference3' => true,
    ];
	
	public function __construct() {
        $this->_accessible = array_change_key_case($this->_accessible, CASE_LOWER);
    }
}
