<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Worksheet Entity
 *
 * @property int $id
 * @property int|null $EntryID
 * @property string|null $AccountCode
 * @property string|null $Description
 * @property string|null $Bal_Dr
 * @property string|null $Bal_Cr
 * @property string|null $CT_Dr
 * @property string|null $CT_Cr
 * @property string|null $UTB_Dr
 * @property string|null $UTB_Cr
 * @property string|null $CurentAdj_Dr
 * @property string|null $CurrentAdj_Cr
 * @property string|null $AdjTB_Dr
 * @property string|null $AdjTB_Cr
 * @property string|null $IS_Dr
 * @property string|null $IS_Cr
 * @property string|null $BS_Dr
 * @property string|null $BS_Cr
 */
class Worksheet extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'EntryID' => true,
        'AccountCode' => true,
        'Description' => true,
        'Bal_Dr' => true,
        'Bal_Cr' => true,
        'CT_Dr' => true,
        'CT_Cr' => true,
        'UTB_Dr' => true,
        'UTB_Cr' => true,
        'CurentAdj_Dr' => true,
        'CurrentAdj_Cr' => true,
        'AdjTB_Dr' => true,
        'AdjTB_Cr' => true,
        'IS_Dr' => true,
        'IS_Cr' => true,
        'BS_Dr' => true,
        'BS_Cr' => true,
    ];
	
	public function __construct() {
        $this->_accessible = array_change_key_case($this->_accessible, CASE_LOWER);
    }
}
