<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\I18n\FrozenTime;

/**
 * Membercapitalbuildups Model
 *
 * @property \App\Model\Table\MembersTable&\Cake\ORM\Association\BelongsTo $Members
 *
 * @method \App\Model\Entity\Membercapitalbuildup newEmptyEntity()
 * @method \App\Model\Entity\Membercapitalbuildup newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup get($primaryKey, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Membercapitalbuildup[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class MembercapitalbuildupsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('membercapitalbuildups');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Members', [
            'foreignKey' => 'memberid',
        ]);
    }
	
	
	
	
    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
       /*  $validator
            ->integer('member_id')
            ->allowEmptyString('member_id');

        $validator
            ->decimal('MonthlyCbu')
            ->allowEmptyString('MonthlyCbu');

        $validator
            ->scalar('DatePaid')
            ->maxLength('DatePaid', 19)
            ->allowEmptyString('DatePaid');

        $validator
            ->scalar('Remarks')
            ->maxLength('Remarks', 58)
            ->allowEmptyString('Remarks');

        $validator
            ->scalar('IsDeduction')
            ->maxLength('IsDeduction', 1)
            ->allowEmptyString('IsDeduction');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        $validator
            ->scalar('UpdateDateTime')
            ->maxLength('UpdateDateTime', 19)
            ->allowEmptyString('UpdateDateTime'); */

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
   /*  public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('member_id', 'Members'), ['errorField' => 'member_id']);

        return $rules;
    } */
	
	public function sumTotalMonthlyCbu(): float
	{
		$query = $this->find();
		$result = $query->select([
				'total' => $query->func()->sum('monthlycbu')
			])
			->first();

		// Check if the result is not null and the total is not null
		if ($result && $result->total !== null) {
			return (float) $result->total;
		} else {
			// Return 0 if the result is null or total is null
			return 0.0;
		}
	}

	
}
