<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Members Model
 *
 * @method \App\Model\Entity\Member newEmptyEntity()
 * @method \App\Model\Entity\Member newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Member[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Member get($primaryKey, $options = [])
 * @method \App\Model\Entity\Member findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Member patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Member[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Member|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Member saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Member[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Member[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Member[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Member[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class MembersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('members');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Users', [
            'foreignKey' => 'user_id',
            'joinType' => 'INNER',
        ]);
       
        $this->hasMany('Membercapitalbuildups', [
            'foreignKey' => 'memberid',
        ]);
        $this->hasMany('Memberschildrens', [
            'foreignKey' => 'memberid',
        ]);
		
        $this->hasMany('Monthlydeductions', [
            'foreignKey' => 'memberid',
        ]);
		
		$this->hasMany('Loanmasters', [
            'foreignKey' => 'memberid',
        ]);
		
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
       /*  $validator
            ->integer('user_id')
            ->notEmptyString('user_id'); */

        $validator
            ->scalar('lastname')
            ->maxLength('lastname', 10)
            ->allowEmptyString('lastname');

        $validator
            ->scalar('firstname')
            ->maxLength('firstname', 15)
            ->allowEmptyString('firstname');

        $validator
            ->scalar('mi')
            ->maxLength('mi', 9)
            ->allowEmptyString('mi');

        /* $validator
            ->scalar('Address')
            ->maxLength('Address', 51)
            ->allowEmptyString('Address');

        $validator
            ->scalar('SpouseName')
            ->maxLength('SpouseName', 21)
            ->allowEmptyString('SpouseName');

        $validator
            ->scalar('DateOfBirth')
            ->maxLength('DateOfBirth', 19)
            ->allowEmptyString('DateOfBirth');

        $validator
            ->scalar('Sex')
            ->maxLength('Sex', 1)
            ->allowEmptyString('Sex');

        $validator
            ->scalar('Height')
            ->maxLength('Height', 6)
            ->allowEmptyString('Height');

        $validator
            ->scalar('Weight')
            ->maxLength('Weight', 6)
            ->allowEmptyString('Weight');

        $validator
            ->scalar('CivilStatus')
            ->maxLength('CivilStatus', 7)
            ->allowEmptyString('CivilStatus');

        $validator
            ->integer('Salary')
            ->allowEmptyString('Salary');

        $validator
            ->scalar('Status')
            ->maxLength('Status', 8)
            ->allowEmptyString('Status');

        $validator
            ->scalar('Education')
            ->maxLength('Education', 64)
            ->allowEmptyString('Education');

        $validator
            ->scalar('Position')
            ->maxLength('Position', 35)
            ->allowEmptyString('Position');

        $validator
            ->scalar('Office')
            ->maxLength('Office', 11)
            ->allowEmptyString('Office');

        $validator
            ->scalar('DateApplied')
            ->maxLength('DateApplied', 19)
            ->allowEmptyString('DateApplied');

        $validator
            ->scalar('DatePaid')
            ->maxLength('DatePaid', 19)
            ->allowEmptyString('DatePaid');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        $validator
            ->scalar('UpdateDateTime')
            ->maxLength('UpdateDateTime', 19)
            ->allowEmptyString('UpdateDateTime'); */

        return $validator;
    }

    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(
			['FirstName', 'LastName', 'DateOfBirth'],
			'Member data already exists. Please check the details again.'
		), 
			['errorField' => 'FirstName']
		);
        //$rules->add($rules->isUnique(['email']), ['errorField' => 'email']);

        return $rules;
    }
	
	 public function countAllMembers(): int
    {
        $totalMembers = $this->find()->count();
        return $totalMembers;
    }
	
}
