<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Transactionlogs Model
 *
 * @method \App\Model\Entity\Transactionlog newEmptyEntity()
 * @method \App\Model\Entity\Transactionlog newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Transactionlog[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Transactionlog get($primaryKey, $options = [])
 * @method \App\Model\Entity\Transactionlog findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Transactionlog patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Transactionlog[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Transactionlog|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Transactionlog saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Transactionlog[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactionlog[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactionlog[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactionlog[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class TransactionlogsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('transactionlogs');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('RowId')
            ->maxLength('RowId', 36)
            ->allowEmptyString('RowId');

        $validator
            ->scalar('TransactionDate')
            ->maxLength('TransactionDate', 19)
            ->allowEmptyString('TransactionDate');

        $validator
            ->scalar('UserId')
            ->maxLength('UserId', 5)
            ->allowEmptyString('UserId');

        $validator
            ->scalar('TableName')
            ->maxLength('TableName', 20)
            ->allowEmptyString('TableName');

        $validator
            ->scalar('TransName')
            ->maxLength('TransName', 6)
            ->allowEmptyString('TransName');

        $validator
            ->scalar('DeviceName')
            ->maxLength('DeviceName', 15)
            ->allowEmptyString('DeviceName');

        $validator
            ->scalar('Description')
            ->allowEmptyString('Description');

        $validator
            ->scalar('Reference1')
            ->maxLength('Reference1', 5)
            ->allowEmptyString('Reference1');

        $validator
            ->scalar('Reference2')
            ->maxLength('Reference2', 6)
            ->allowEmptyString('Reference2');

        $validator
            ->scalar('Reference3')
            ->maxLength('Reference3', 26)
            ->allowEmptyString('Reference3');

        return $validator;
    }
}
