<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Worksheets Model
 *
 * @method \App\Model\Entity\Worksheet newEmptyEntity()
 * @method \App\Model\Entity\Worksheet newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Worksheet[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Worksheet get($primaryKey, $options = [])
 * @method \App\Model\Entity\Worksheet findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Worksheet patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Worksheet[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Worksheet|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Worksheet saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Worksheet[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Worksheet[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Worksheet[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Worksheet[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class WorksheetsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('worksheets');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        /* $validator
            ->allowEmptyString('EntryID');

        $validator
            ->scalar('AccountCode')
            ->maxLength('AccountCode', 5)
            ->allowEmptyString('AccountCode');

        $validator
            ->scalar('Description')
            ->maxLength('Description', 33)
            ->allowEmptyString('Description');

        $validator
            ->decimal('Bal_Dr')
            ->allowEmptyString('Bal_Dr');

        $validator
            ->decimal('Bal_Cr')
            ->allowEmptyString('Bal_Cr');

        $validator
            ->decimal('CT_Dr')
            ->allowEmptyString('CT_Dr');

        $validator
            ->decimal('CT_Cr')
            ->allowEmptyString('CT_Cr');

        $validator
            ->decimal('UTB_Dr')
            ->allowEmptyString('UTB_Dr');

        $validator
            ->decimal('UTB_Cr')
            ->allowEmptyString('UTB_Cr');

        $validator
            ->decimal('CurentAdj_Dr')
            ->allowEmptyString('CurentAdj_Dr');

        $validator
            ->decimal('CurrentAdj_Cr')
            ->allowEmptyString('CurrentAdj_Cr');

        $validator
            ->decimal('AdjTB_Dr')
            ->allowEmptyString('AdjTB_Dr');

        $validator
            ->decimal('AdjTB_Cr')
            ->allowEmptyString('AdjTB_Cr');

        $validator
            ->decimal('IS_Dr')
            ->allowEmptyString('IS_Dr');

        $validator
            ->decimal('IS_Cr')
            ->allowEmptyString('IS_Cr');

        $validator
            ->decimal('BS_Dr')
            ->allowEmptyString('BS_Dr');

        $validator
            ->decimal('BS_Cr')
            ->allowEmptyString('BS_Cr'); */

        return $validator;
    }
}
