<?php
declare(strict_types=1);

namespace App\View\Cell;

use Cake\View\Cell;


class CommonCell extends Cell
{
    protected $_validCellOptions = [];


    public function initialize(): void
    {
    }

    public function display(){
		
    }
	
	public function setting($req=null){
		
		$settings = $this->getTableLocator()->get('Settings');
		$setting  = $settings->get(1, ['contain' => []]);			
		$this->set('setting', '');
		if(!empty($setting)){
			if(isset($req) && !empty($req)){
				$this->set('setting', $setting->{$req});
			}
		}
		
	}
	
	
	
	public function userprofile($id, $refid){
		$this->LoadModel('Users');
		$user = $this->Users
			->find()
			->where(['id' => $id, 'refid' => $refid])
			->contain([])
			->first();
			
		$this->set('user', $user);
	}
	
	public function usermenu($user){
		$this->LoadModel('Roles');
		$role = $this->Roles
			->find()
			->select(['slug'])
			->where(['id' => $user['role_id']])
			->contain([])
			->first();
			
		$this->set('role', $role);
		$this->set('user', $user);
	}
	
	public function salescomparison(){
		$this->LoadModel('Sales');
		
		$current_year 		= date("Y");
		$fprevious_year 		= ($current_year - 1);
		$sprevious_year 	= ($current_year - 2);
		
		$total_sales = $this->Sales->find();		
		$count_sales  = $total_sales->select(['sum' => $total_sales->func()->sum('Sales.total')]);
		
		
		for($i=1; $i<=12; $i++){
			$mos[$i] = $i;
		}
		
		
				$cod1 	= $count_sales->where(['YEAR(created)' => $current_year])->first();
				$current_sales = $cod1->sum;
				
				$mcod = $this->Sales->find()
				->select(['total_sales' => 'SUM(Sales.total)', 'mo' => 'MONTH(Sales.created)'])
				->where(['YEAR(created)' => $current_year])
				->group(['MONTH(created)'])
				->all();
				
				foreach($mcod as $d):
					$found_data[$d->mo] = $d->total_sales;
				endforeach;

				foreach($mos as $key => $mo):			
					$new_data[$key] = isset($found_data[$key]) ? $found_data[$key] : "0";			
				endforeach;
				
			
				$cod2 	= $count_sales->where(['YEAR(created)' => $fprevious_year])->first();
				$fcurrent_sales = $cod2->sum;
				
				$smcod = $this->Sales->find()
				->select(['total_sales' => 'SUM(Sales.total)', 'mo' => 'MONTH(Sales.created)'])
				->where(['YEAR(created)' => $fprevious_year])
				->group(['MONTH(created)'])
				->all();
				
				foreach($smcod as $d):
					$sfound_data[$d->mo] = $d->total_sales;
				endforeach;

				foreach($mos as $key => $mo):			
					$snew_data[$key] = isset($sfound_data[$key]) ? $sfound_data[$key] : "0";			
				endforeach;
				
				/* $cod3 	= $count_sales->where(['YEAR(created)' => $sprevious_year])->first();
				$scurrent_sales = $cod3->sum;		 */
		
		
		
		
		$this->set('current_total_sale', $current_sales);
		$this->set('fprevious_total_sale', $fcurrent_sales);
		//$this->set('sprevious_total_sale', $scurrent_sales);
		$this->set('mcod', $new_data);
		$this->set('smcod', $snew_data);
		
		
		$this->set('current_year', $current_year);
		$this->set('fprevious_year', $fprevious_year);
		//$this->set('sprevious_year', $sprevious_year);
	}
	
}
