<?php
/**
 * Routes configuration.
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * It's loaded within the context of `Application::routes()` method which
 * receives a `RouteBuilder` instance `$routes` as method argument.
 *
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 */

use Cake\Routing\Route\DashedRoute;

use Cake\Routing\RouteBuilder;

return static function (RouteBuilder $routes) {
    /*
     * The default class to use for all routes
     *
     * The following route classes are supplied with CakePHP and are appropriate
     * to set as the default:
     *
     * - Route
     * - InflectedRoute
     * - DashedRoute
     *
     * If no call is made to `Router::defaultRouteClass()`, the class used is
     * `Route` (`Cake\Routing\Route\Route`)
     *
     * Note that `Route` does not do any inflections on URLs which will result in
     * inconsistently cased URLs when used with `{plugin}`, `{controller}` and
     * `{action}` markers.
     */
    $routes->setRouteClass(DashedRoute::class);

    $routes->scope('/', function (RouteBuilder $builder) {
		
        /*
         * Here, we are connecting '/' (base path) to a controller called 'Pages',
         * its action called 'display', and we pass a param to select the view file
         * to use (in this case, templates/Pages/home.php)...
         */
        //$builder->connect('/', ['controller' => 'pages', 'action' => 'login', 'home']);
		  $builder->redirect(
			'/',
			['controller' => 'users', 'action' => 'logout'],
			['persist' => false, 'prefix' => 'admin']
			// Or ['persist'=>['id']] for default routing where the
			// view action expects $id as an argument.
		); 
		
        /*
         * ...and connect the rest of 'Pages' controller's URLs.
         */
     //   $builder->connect('/articles/*', ['controller' => 'Articles', 'action' => 'view']);

        /*
         * Connect catchall routes for all controllers.
         *
         * The `fallbacks` method is a shortcut for
         *
         * ```
         * $builder->connect('/{controller}', ['action' => 'index']);
         * $builder->connect('/{controller}/{action}/*', []);
         * ```
         *
         * You can remove these routes once you've connected the
         * routes you want in your application.
         */
        $builder->fallbacks();
    });
	
	$routes->prefix('Admin', ['_namePrefix' => 'admin:'], function (RouteBuilder $routes) {
		//$routes->connect('/{controller}/{action}');
		
		/*qr code*/
		$routes->connect('/ballots/generateQrCode', ['controller' => 'ballots', 'action' => 'generateQrCode']);
		
		$routes->connect('/settings/system-statistics', ['controller' => 'settings', 'action' => 'dashboard']);
		
		/*---------------
		User Routes
		---------------*/
		
		$routes->connect('/users/create-new-user', ['controller' => 'users', 'action' => 'add']);
		$routes->connect('/users/upload-users', ['controller' => 'users', 'action' => 'upload']);
		//$routes->connect('/users/show-all-members', ['controller' => 'users', 'action' => 'index']);
		
		$routes->connect(
			'/users/show-all-members',
			['controller' => 'users', 'action' => 'index']
		);
		
		
		$routes->connect('/users/users-masterlist-report', ['controller' => 'users', 'action' => 'index']);
		$routes->connect('/users/view-user-profile/{refid}-{id}',[ 'controller' => 'users', 'action' => 'view'])
		->setPass(['id', 'refid'])
		->setPatterns([
			'id' => '[0-9]+',
		]);
		
		$routes->connect('/users/update-user/{refid}-{id}-{type}',[ 'controller' => 'users', 'action' => 'edit'])
		->setPass(['id', 'refid', 'type'])
		->setPatterns([
			'id' => '[0-9]+',
		]);
		
		$routes->connect('/users/avatar/{refid}-{id}',[ 'controller' => 'users', 'action' => 'avatar'])
		->setPass(['id', 'refid'])
		->setPatterns([
			'id' => '[0-9]+',
		]);
		
		$routes->connect(
			'/users/download/{role_id}-{status}-{download_type}',
			['controller' => 'users', 'action' => 'download']
		)
		->setPass(['role_id', 'status', 'download_type'])
		->setPatterns([
			'role_id' => '[0-9]+',
		]);
		
		$routes->connect(
			'/users/resetaccount/{refid}-{user_id}-{reset_type}',
			['controller' => 'users', 'action' => 'resetaccount']
		)
		->setPass(['refid', 'user_id', 'reset_type'])
		->setPatterns([
			'user_id' => '[0-9]+',
		]);
		
		$routes->connect(
			'/users/generatecode/{step}-{type}',
			['controller' => 'users', 'action' => 'generatecode']
		)
		->setPass(['step', 'type']);
		
		/*----------------
		Position Routes
		----------------*/
		$routes->connect('/positions/show-positions-masterlist', ['controller' => 'positions', 'action' => 'index']);
		
		/*----------------
		Candidates Routes
		----------------*/
		$routes->connect('/candidates/show-candidates-masterlist', ['controller' => 'candidates', 'action' => 'index']);
		
		/*----------------
		Ballots Routes
		----------------*/
		$routes->connect('/ballots/show-ballots-masterlist', ['controller' => 'ballots', 'action' => 'index']);

		/*----------------
		Members Routes
		----------------*/
		$routes->connect('/members/show-members-list', ['controller' => 'members', 'action' => 'index']);

		/*----------------
		Members Routes
		----------------*/
		$routes->connect('/loanmasters/show-loans-list', ['controller' => 'loanmasters', 'action' => 'index']);
		
		$routes->connect('/chartofaccounts/show-chart-list', ['controller' => 'chartofaccounts', 'action' => 'index']);
		
		$routes->connect('/transactionmasters/show-transaction-list', ['controller' => 'transactionmasters', 'action' => 'index']);
		$routes->connect('/monthlydeductions/show-deductions-list', ['controller' => 'monthlydeductions', 'action' => 'index']);
		
		/*--------------
		Change Request
		----------------*/
		$routes->connect('/changerequests/show-request-list', ['controller' => 'changerequests', 'action' => 'index']);
		
		/*--------------
		Monthly Deductions
		----------------*/
		$routes->connect('/monthlydeductions/show-list-of-deductions', ['controller' => 'monthlydeductions', 'action' => 'index']);

		
		
		/*----------------
		UAM Masterlist
		----------------*/
		$routes->connect('/uams/uam-masterlist', ['controller' => 'uams', 'action' => 'index']);
		$routes->connect('/uams/create-new-access-matrix', ['controller' => 'uams', 'action' => 'add']);
		$routes->connect('/pages/download-members-upload-file/', ['controller' => 'pages', 'action' => 'download', 'members_upload.xlsx']);
		
		$routes->fallbacks(DashedRoute::class);		
		
		
		
	});
	
	$routes->prefix('Member', ['_namePrefix' => 'member:'], function (RouteBuilder $routes) {
		
		$routes->connect('/{controller}/{action}');

		/*---------------
		User Routes
		---------------*/
		$routes->connect('/users/my-profile', ['controller' => 'users', 'action' => 'view']);
		
	});
	
	
	
	$routes->connect(
        '/articles/{id}-{slug}', // For example, /blog/3-CakePHP_Rocks
        ['controller' => 'Articles', 'action' => 'view']
    )
    // Define the route elements in the route template
    // to prepend as function arguments. Order matters as this
    // will pass the `$id` and `$slug` elements as the first and
    // second parameters. Any additional passed parameters in your
    // route will be added after the setPass() arguments.
    ->setPass(['id', 'slug'])
    // Define a pattern that `id` must match.
    ->setPatterns([
        'id' => '[0-9]+',
    ]);
	
    /*
     * If you need a different set of middleware or none at all,
     * open new scope and define routes there.
     *
     * ```
     * $routes->scope('/api', function (RouteBuilder $builder) {
     *     // No $builder->applyMiddleware() here.
     *
     *     // Parse specified extensions from URLs
     *     // $builder->setExtensions(['json', 'xml']);
     *
     *     // Connect API actions here.
     * });
     * ```
     */
};
