<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Loandetail> $loandetails
 */
?>
<div class="loandetails index content">
    <?= $this->Html->link(__('New Loandetail'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Loandetails') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('Id') ?></th>
                    <th><?= $this->Paginator->sort('LoanMasterId') ?></th>
                    <th><?= $this->Paginator->sort('AmortizationDate') ?></th>
                    <th><?= $this->Paginator->sort('MonthlyAmortization') ?></th>
                    <th><?= $this->Paginator->sort('Principal') ?></th>
                    <th><?= $this->Paginator->sort('Interest') ?></th>
                    <th><?= $this->Paginator->sort('Status') ?></th>
                    <th><?= $this->Paginator->sort('Remarks') ?></th>
                    <th><?= $this->Paginator->sort('EntryDate') ?></th>
                    <th><?= $this->Paginator->sort('UpdateDateTime') ?></th>
                    <th><?= $this->Paginator->sort('PayDate') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($loandetails as $loandetail): ?>
                <tr>
                    <td><?= $this->Number->format($loandetail->Id) ?></td>
                    <td><?= $loandetail->LoanMasterId === null ? '' : $this->Number->format($loandetail->LoanMasterId) ?></td>
                    <td><?= h($loandetail->AmortizationDate) ?></td>
                    <td><?= $loandetail->MonthlyAmortization === null ? '' : $this->Number->format($loandetail->MonthlyAmortization) ?></td>
                    <td><?= $loandetail->Principal === null ? '' : $this->Number->format($loandetail->Principal) ?></td>
                    <td><?= $loandetail->Interest === null ? '' : $this->Number->format($loandetail->Interest) ?></td>
                    <td><?= h($loandetail->Status) ?></td>
                    <td><?= h($loandetail->Remarks) ?></td>
                    <td><?= h($loandetail->EntryDate) ?></td>
                    <td><?= h($loandetail->UpdateDateTime) ?></td>
                    <td><?= h($loandetail->PayDate) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $loandetail->Id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $loandetail->Id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $loandetail->Id], ['confirm' => __('Are you sure you want to delete # {0}?', $loandetail->Id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
