<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Loanmaster $loanmaster
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Loanmaster'), ['action' => 'edit', $loanmaster->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Loanmaster'), ['action' => 'delete', $loanmaster->id], ['confirm' => __('Are you sure you want to delete # {0}?', $loanmaster->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Loanmasters'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Loanmaster'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="loanmasters view content">
            <h3><?= h($loanmaster->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('LoanType') ?></th>
                    <td><?= h($loanmaster->LoanType) ?></td>
                </tr>
                <tr>
                    <th><?= __('AmortizationStart') ?></th>
                    <td><?= h($loanmaster->AmortizationStart) ?></td>
                </tr>
                <tr>
                    <th><?= __('AmortizationEnd') ?></th>
                    <td><?= h($loanmaster->AmortizationEnd) ?></td>
                </tr>
                <tr>
                    <th><?= __('ApprovedDate') ?></th>
                    <td><?= h($loanmaster->ApprovedDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($loanmaster->Status) ?></td>
                </tr>
                <tr>
                    <th><?= __('EntryDate') ?></th>
                    <td><?= h($loanmaster->EntryDate) ?></td>
                </tr>
                <tr>
                    <th><?= __('UpdateDateTime') ?></th>
                    <td><?= h($loanmaster->UpdateDateTime) ?></td>
                </tr>
                <tr>
                    <th><?= __('Remarks') ?></th>
                    <td><?= h($loanmaster->Remarks) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($loanmaster->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('MemberId') ?></th>
                    <td><?= $loanmaster->MemberId === null ? '' : $this->Number->format($loanmaster->MemberId) ?></td>
                </tr>
                <tr>
                    <th><?= __('ApprovedLoanAmount') ?></th>
                    <td><?= $loanmaster->ApprovedLoanAmount === null ? '' : $this->Number->format($loanmaster->ApprovedLoanAmount) ?></td>
                </tr>
                <tr>
                    <th><?= __('MonthsToPay') ?></th>
                    <td><?= $loanmaster->MonthsToPay === null ? '' : $this->Number->format($loanmaster->MonthsToPay) ?></td>
                </tr>
                <tr>
                    <th><?= __('ServiceFee') ?></th>
                    <td><?= $loanmaster->ServiceFee === null ? '' : $this->Number->format($loanmaster->ServiceFee) ?></td>
                </tr>
                <tr>
                    <th><?= __('PercentInterest') ?></th>
                    <td><?= $loanmaster->PercentInterest === null ? '' : $this->Number->format($loanmaster->PercentInterest) ?></td>
                </tr>
                <tr>
                    <th><?= __('Penalty') ?></th>
                    <td><?= $loanmaster->Penalty === null ? '' : $this->Number->format($loanmaster->Penalty) ?></td>
                </tr>
                <tr>
                    <th><?= __('NetAmountOfLoan') ?></th>
                    <td><?= $loanmaster->NetAmountOfLoan === null ? '' : $this->Number->format($loanmaster->NetAmountOfLoan) ?></td>
                </tr>
                <tr>
                    <th><?= __('Insurance') ?></th>
                    <td><?= $loanmaster->Insurance === null ? '' : $this->Number->format($loanmaster->Insurance) ?></td>
                </tr>
                <tr>
                    <th><?= __('PercentCapitalBuildUp') ?></th>
                    <td><?= $loanmaster->PercentCapitalBuildUp === null ? '' : $this->Number->format($loanmaster->PercentCapitalBuildUp) ?></td>
                </tr>
                <tr>
                    <th><?= __('PrePayments') ?></th>
                    <td><?= $loanmaster->PrePayments === null ? '' : $this->Number->format($loanmaster->PrePayments) ?></td>
                </tr>
                <tr>
                    <th><?= __('OtherDeductions') ?></th>
                    <td><?= $loanmaster->OtherDeductions === null ? '' : $this->Number->format($loanmaster->OtherDeductions) ?></td>
                </tr>
                <tr>
                    <th><?= __('MonthlyAmortization') ?></th>
                    <td><?= $loanmaster->MonthlyAmortization === null ? '' : $this->Number->format($loanmaster->MonthlyAmortization) ?></td>
                </tr>
                <tr>
                    <th><?= __('OtherPayments') ?></th>
                    <td><?= $loanmaster->OtherPayments === null ? '' : $this->Number->format($loanmaster->OtherPayments) ?></td>
                </tr>
                <tr>
                    <th><?= __('LessRebates') ?></th>
                    <td><?= $loanmaster->LessRebates === null ? '' : $this->Number->format($loanmaster->LessRebates) ?></td>
                </tr>
                <tr>
                    <th><?= __('OtherDeductionsPrePayment') ?></th>
                    <td><?= $loanmaster->OtherDeductionsPrePayment === null ? '' : $this->Number->format($loanmaster->OtherDeductionsPrePayment) ?></td>
                </tr>
                <tr>
                    <th><?= __('OtherDeductionsCanteen') ?></th>
                    <td><?= $loanmaster->OtherDeductionsCanteen === null ? '' : $this->Number->format($loanmaster->OtherDeductionsCanteen) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
