(function($) {
  'use strict';
  $(function() {
 if ($("#salesTopChart").length) {
    var graphGradient = document.getElementById("salesTopChart").getContext('2d');;
    var saleGradientBg = graphGradient.createLinearGradient(25, 0, 25, 110);
    saleGradientBg.addColorStop(0, 'rgba(242,18,94, 1)');
    saleGradientBg.addColorStop(1, 'rgba(255, 255, 255, 1)');
    var salesTopData = {
        labels: [
        "Jan",        
        "Feb",        
        "Mar",        
        "Apr",        
        "May",        
        "Jun",        
        "Jul",        
        "Aug",        
        "Sep",        
        "Oct",        
        "Nov",        
        "Dec",        
        ],
        datasets: [{
            label: '# of Votes',
            data: [80, 79, 78, 65, 77, 68, 63, 73, 58, 46, 60],
            backgroundColor: saleGradientBg,
            borderColor: [
                'rgba(242,18,94)',
            ],
            borderWidth: 2,
            fill: true, 
        }]
    };

    var salesTopOptions = {
        scales: {
            yAxes: [{
              display: true,
                gridLines: {
                    display: true,
                    drawBorder: true,
                },
                ticks: {
                  display: false,
                  beginAtZero: true,
                }
            }],
            xAxes: [{
              display: true,
                gridLines: {
                    display: true,
                    drawBorder: false,
                },
                ticks: {
                    beginAtZero: true,
                    maxTicksLimit: 4,
                    maxRotation: 360,
                    minRotation: 360,
                    padding: 10
                }
            }],
        },
        legend: {
            display: false
        },
        elements: {
          point: {
            radius: 0
        },
            line: {
                tension: 0.1,
            }
        },
        tooltips: {
            backgroundColor: 'rgba(31, 59, 179, 1)',
        }
    }
    var salesTop = new Chart(graphGradient, {
        type: 'line',
        data: salesTopData,
        options: salesTopOptions
    });
}


  });
})(jQuery);