<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;
use Cake\I18n\FrozenTime;

class LoanmastersController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
	public function reloan($id=null, $balance=null){
		//$this->ajaxLayout();
		if($this->request->is('ajax')){
			//$this->ajaxLayout();
			$loan = $this->Loanmasters->get($id, ['contain' => []]);
			$this->set('loan', $loan);
			$this->set('balance', $balance);
		}
	}
	
	public function newloan(){
		
		if($this->request->is('ajax')){
			//$this->ajaxLayout();
			$loan = $this->Loanmasters->newEmptyEntity();
			$this->set(compact('loan'));
		
		}
	}
	

	public function index(){
		
		
		
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			$member = $this->getMemberData();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Loanmasters.ApprovedDate' => "DESC"]; //$columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Loanmasters.member_id' => $searchValue];									
			}
			
			$where[] = ['Loanmasters.id >' => 0, 'memberid' => $member->id];
			
			$q1 = $this->Loanmasters->find()
					->where($where)
					->contain(['Members'])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Loanmasters->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Loanmasters->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)


	->offset($row);
			}
			
			
			if(!empty($datas)):
				foreach($datas as $u):
					/* $_link = Router::url(
						['controller' => 'Loanmasters', 'action' => 'view', $u->id]
					);
						
					$view_link = '<a href="'.$_link.'" 
					title ="Loan Details" 
					class = "dropdown-item btn btn-xs btn-outline-success"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> View Details</div></a>';
					
					$link2 = '<a href="'.$_link.'" 
					title ="Member Profile" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view text-black bold">'.$u->name.'</a>';
					
					$update_link = Router::url(
						['controller' => 'loanmasters', 'action' => 'printtheform', $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Print / Download" 
					class = "dropdown-item btn btn-xs btn-outline-success"><div class="preview-thumbnail">
					<i class="typcn typcn-printer menu-icon"></i> Print / Download </div></a>';
					
					$reassign = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->id, "reassign"]
					);
					
					$reassign = '<a href="'.$reassign.'" 
					title ="Change Account Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-user menu-icon"></i> Change Role</div></a>';

					$actions = $view_link . $update_link;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                           
                           '.$actions.'
                          </div>
                        </div>'; */
						
					
								
				   $_data[] = array( 
						
						'type'			=> '<span class="bold text-uppercase">'.$u->loantype.'</span>',	
						'amount'		=> '<span class="bold pull-right">'.number_format($u->approvedloanamount, 2, ".", ",").'</span>',					
						'topay'			=> $u->monthstopay,				
						//'net'			=> '<span class="bold">'.$u->NetAmountOfLoan.'</span>',	
						//'approve'		=> '<span class="bold text-uppercase">'.$u->ApprovedDate->format('m/d/Y').'</span>',
						'status'		=> '<span class="bold '.($u->status=="COMPLETED" ? "text-success" : "text-danger").'">'.$u->status.'</span>',
						//'entry'			=> '<span class="bold">'.$u->EntryDate->format('m/d/Y').'</span>',
											
					);
					
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	public function loanpayments(){
		
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			$member = $this->getMemberData();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Loanmasters.ApprovedDate' => "DESC"]; //$columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Loanmasters.member_id' => $searchValue];									
			}
			
			$where[] = ['Loanmasters.id >' => 0, 'memberid' => $member->id];
			
			$q1 = $this->Loanmasters->find()
					->where($where)
					->contain(['Transactionmasters'])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
					$datas = $this->Loanmasters->find()
					->where($where)
					->contain(['Transactionmasters'])
					->order($orderby);
			}else{	
				$datas = $this->Loanmasters->find()
					->where($where)
					->contain(['Transactionmasters'])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			
			if(!empty($datas)):
				$str = '0';
				foreach($datas as $u):	
				  if(!empty($u->transactionmasters)){
					foreach($u->transactionmasters as $t):						
						$str ='<div>'.$t->amount.'</div>';
						//$str .='<div>'.$t->entrydate.'</div>';
					endforeach;
				  }
				  
				   $_data[] = array( 
						
						'type'			=> '<span class="bold text-uppercase">'.$u->id.'</span>',	
						'amount'		=> '<span class="bold pull-right">'.number_format($u->approvedloanamount, 2, ".", ",").'</span>',					
						'topay'			=> $str,				
						//'net'			=> '<span class="bold">'.$u->NetAmountOfLoan.'</span>',	
						//'approve'		=> '<span class="bold text-uppercase">'.$u->ApprovedDate->format('m/d/Y').'</span>',
						'status'		=> '<span class="bold '.($u->status=="COMPLETED" ? "text-success" : "text-danger").'">'.$u->status.'</span>',
						//'entry'			=> '<span class="bold">'.$u->EntryDate->format('m/d/Y').'</span>',
											
					);
					
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	
	private function processMonthlyAmortization($data=null, $loanid=null){
		
		//$loan = $loanTable->newEmptyEntity();
		$mos = $data['MonthsToPay'];
		
		$loans = [];
		
		
		
		for ($month = 1; $month <= $mos; $month++) {
			//$loan = $loanTable->newEmptyEntity();

			// Assign values from form_data or calculate them
			/* $loan->LoanMasterId 		= $loanid;
			$loan->AmortizationDate 	= $this->calculateAmortizationDate($month, $data['AmortizationStart']);
			$loan->MonthlyAmortization 	= $data['AmortizationStart'];
			$loan->Principal 			= $data['monthly_principal'];
			$loan->Interest 			= $data['monthly_interest'];
			$loan->Status 				= "UNPAID"; 
			$loan->EntryDate 			= new FrozenTime();
			$loan->UpdateDateTime 		= new FrozenTime();
			  */

			//$loans[] = $loan;
			$loans[] = [
				'LoanMasterId' 			=> $loanid,
				'AmortizationDate' 		=> $this->calculateAmortizationDate($month, $data['AmortizationStart']),
				'MonthlyAmortization' 	=> $data['MonthlyAmortization'],
				'Principal' 			=> $data['monthly_principal'],
				'Interest' 				=> $data['monthly_interest'],
				'Status' 				=> "UNPAID",
				'EntryDate' 			=> new FrozenTime(),
				'UpdateDateTime' 		=> new FrozenTime()
			];
		}
		
		$loanTable = $this->getTableLocator()->get('Loandetails');
		$loan_data = $loanTable->newEntities($loans);
		
		//$this->log("Data " . json_encode($loans));
		
		$result = $loanTable->saveMany($loan_data);
		if($result) {
			$this->log("Loan details has been process| LOAN ID | " . $loanid);
		}else{
			$this->log("Loan details failed to process| LOAN ID | " . $loanid);
		}
 
	}
	
	private function calculateAmortizationDate($month, $startDate) {
		$date = new FrozenTime($startDate);

		// Add months to the date
		$date = $date->addMonths($month);

		// Check if the day of the month has changed after adding the months
		if ($date->day !== (new FrozenTime($startDate))->addMonths($month)->day) {
			// If the day has changed, subtract days to adjust for shorter months
			$date = $date->subDay($date->day);
		}

		// Return the formatted date
		return $date->i18nFormat('yyyy-MM-dd');
	}




	
	public function printtheform($loanid=null){
		$loan = $this->Loanmasters->get($loanid, ['contain' => ['Members']]);
		$this->set(compact('loan'));
	}
		
	public function print($loanid=null){
		$this->viewBuilder()->setLayout('print');
		$loan = $this->Loanmasters->get($loanid, ['contain' => ['Members']]);
		$this->set(compact('loan'));
	}
	
   
}
