<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Routing\Router;

class MemberschildrensController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
   public function index(){
		if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 					= $this->request->getData();
			$draw 					= $data['draw'];
			$row 					= $data['start']; //page
			$rowperpage 			= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 			= $data['order'][0]['column']; //Column index
			$columnName 			= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
						
			
			$orderby = ['Memberschildrens.ChildName' => $columnSortOrder];
				
			if(isset($data['search']['value']) && !empty($data['search']['value'])){
				$searchValue = $data['search']['value']; 
				$where[] = ['Memberschildrens.ChildName LIKE' => '%'.$searchValue.'%'];
								
			}
			
			$where[] = ['Memberschildrens.id >' => 0];
			
			$q1 = $this->Memberschildrens->find()
					->where($where)
					->contain([])
					->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$datas = $this->Memberschildrens->find()
					->where($where)
					->contain([])
					->order($orderby);
			}else{	
				$datas = $this->Memberschildrens->find()
					->where($where)
					->contain([])
					->order($orderby)
					->limit($rowperpage)
					->offset($row);
			}
			
			
			if(!empty($datas)):
				foreach($datas as $u):
					$_link = Router::url(
						['controller' => 'Memberschildrens', 'action' => 'view', $u->id]
					);
					
					$link = '<a href="'.$_link.'" 
					title ="Account Details" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "modal_view dropdown-item"><div class="preview-thumbnail">View</div></a>';
					
					$view_link = '<a href="'.$_link.'" 
					title ="Account Details" 
					class = "dropdown-item btn btn-xs btn-outline-success"><div class="preview-thumbnail">
					<i class="typcn typcn-eye menu-icon"></i> View Details</div></a>';
					
					$link2 = '<a href="'.$_link.'" 
					title ="Member Profile" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item modal_view text-black bold">'.$u->name.'</a>';
					
					$update_link = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->id]
					);
					
					$update_link = '<a href="'.$update_link.'" 
					title ="Update Account" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-edit menu-icon"></i> Make Changes</div></a>';
					
					$reassign = Router::url(
						['controller' => 'users', 'action' => 'edit', $u->id, "reassign"]
					);
					
					$reassign = '<a href="'.$reassign.'" 
					title ="Change Account Role" 
					data-toggle = "modal" 
					data-target = "#view_modal"
					class = "dropdown-item btn btn-xs btn-outline-success modal_view"><div class="preview-thumbnail">
					<i class="typcn typcn-user menu-icon"></i> Change Role</div></a>';

					$actions = $view_link . $update_link;
					
					$act = '      <div class="dropdown">
                          <button class="btn btn-outline-info btn-sm dropdown-toggle" type="button" id="dropdownMenuIconButton6" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <i class="typcn typcn-lock-closed"></i>
                          </button>
                          <div class="dropdown-menu" aria-labelledby="dropdownMenuIconButton6">
                           
                           '.$actions.'
                          </div>
                        </div>';
						
				   $_data[] = array( 
						'fname'				=> '<span class="bold">'.$u->ChildName.'</span>',			
						'action'			=> $act
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
	}
	
	
	public function add($member=null){
		
			$child = $this->Memberschildrens->newEmptyEntity();
			if ($this->request->is('post')) {
				$this->ajaxLayout();
				$code = 0;
				
				$data = $this->request->getData();				
				$child = $this->Memberschildrens->patchEntity($child, $data,  ['validate' => false]);
				
				$error = $this->showError($child);
						
				if(!empty($error)) {
					$this->Log(json_encode($child->getErrors()));
					$msg = '<span class="text-danger">'.$error.'</span>';
				}else{
					if(!empty($member)){
						$child->member_id = $member;
					
						if ($this->Memberschildrens->save($child)) {
							
							$code = 1; 
							$msg = '<div class="text-success">Child data successfully registered</div>';
							
						}else{
							$error = $this->showError($child);
							$this->Log(json_encode($child->getErrors()));
							$msg = '<span class="text-danger">'.$error.'</span>';
						}
					}else{
						$msg = '<div class="text-danger">Invalid member data</div>';
					}
				} 
					
				$resp = ['code' => $code, 'msg' => $msg];
				
				
				$this->response = $this->response->withType('application/json')
				->withStringBody(json_encode($resp));
				
				return $this->response;
			}

			$this->set(compact('child', 'member'));
		
    }
	
	public function edit($id=null, $issave=false){
				
			
			$child = $this->Memberschildrens->get($id, [
				'contain' => [],
			]);
			
			
			if($this->request->is('ajax') && $issave) {
					$this->log(json_encode($this->request->getData()));
					$this->ajaxLayout();
					$code = 0;
				
						$data = $this->request->getData();				
						$child = $this->Memberschildrens->patchEntity($child, $data, ['validate' => false]);
						
						$error = $this->showError($child);
								
						if(!empty($error)) {
							$this->Log(json_encode($child->getErrors()));
							$msg = '<span class="text-danger">'.$error.'</span>';
						}else{
							

							if ($this->Memberschildrens->save($child)) {
								
								$code = 1; 
								$msg = '<div class="text-success">Data changes has been saved.</div>';
								
							}else{
								$error = $this->showError($child);
								$this->Log(json_encode($child->getErrors()));
								$msg = '<span class="text-danger">'.$error.'</span>';
							}
						} 
							
						$resp = ['code' => $code, 'msg' => $msg];
						
						
						$this->response = $this->response->withType('application/json')
						->withStringBody(json_encode($resp));
						
						return $this->response;
			}
			
			$this->set(compact('child'));
			
		
    }


   
}
