<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Systemcounters Controller
 *
 * @property \App\Model\Table\SystemcountersTable $Systemcounters
 * @method \App\Model\Entity\Systemcounter[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class SystemcountersController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $systemcounters = $this->paginate($this->Systemcounters);

        $this->set(compact('systemcounters'));
    }

    /**
     * View method
     *
     * @param string|null $id Systemcounter id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $systemcounter = $this->Systemcounters->get($id, [
            'contain' => [],
        ]);

        $this->set(compact('systemcounter'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $systemcounter = $this->Systemcounters->newEmptyEntity();
        if ($this->request->is('post')) {
            $systemcounter = $this->Systemcounters->patchEntity($systemcounter, $this->request->getData());
            if ($this->Systemcounters->save($systemcounter)) {
                $this->Flash->success(__('The systemcounter has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The systemcounter could not be saved. Please, try again.'));
        }
        $this->set(compact('systemcounter'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Systemcounter id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $systemcounter = $this->Systemcounters->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $systemcounter = $this->Systemcounters->patchEntity($systemcounter, $this->request->getData());
            if ($this->Systemcounters->save($systemcounter)) {
                $this->Flash->success(__('The systemcounter has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The systemcounter could not be saved. Please, try again.'));
        }
        $this->set(compact('systemcounter'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Systemcounter id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $systemcounter = $this->Systemcounters->get($id);
        if ($this->Systemcounters->delete($systemcounter)) {
            $this->Flash->success(__('The systemcounter has been deleted.'));
        } else {
            $this->Flash->error(__('The systemcounter could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
