<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;

/**
 * Uams Controller
 *
 * @property \App\Model\Table\UamsTable $Uams
 * @method \App\Model\Entity\Uam[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UamsController extends AppController
{
	
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
		//$this->Authentication->allowUnauthenticated(['login', 'register', 'unauthorized']);
	}
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $this->paginate = [
            'contain' => ['Groups'],
        ];
        $uams = $this->paginate($this->Uams);

        $this->set(compact('uams'));
    }

    /**
     * View method
     *
     * @param string|null $id Uam id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $uam = $this->Uams->get($id, [
            'contain' => ['Groups'],
        ]);

        $this->set(compact('uam'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add(){
        $uam = $this->Uams->newEmptyEntity();
		
        if ($this->request->is('post')) {
			$this->ajaxLayout();
			$resp = 0;
			$data = $this->request->getData();
			//$uam = $this->Uams->patchEntity($uam , $data);
			
					/* $error = $this->showError($uam);
					
					if(!empty($error)) {
						$this->Log(json_encode($uam ->getErrors()));
						$msg = '<span class="text-danger">'.$error.'</span>';
					}else{ */
						$uam_data = array();
						
						if(isset($data['election_module']) && !empty($data['election_module'])){
							$uam_data[] = [
								'group_id' 		=> $data['group_id'],
								'controller' 	=> 'elections',
								'actions' 		=> implode(",", $data['election_module'])
							];
						}
						
						if(isset($data['user_module']) && !empty($data['user_module'])){
							$uam_data[] = [
								'group_id' 		=> $data['group_id'],
								'controller' 	=> 'users',
								'actions' 		=> implode(",", $data['user_module'])
							];
						}
						
						if(!empty($uam_data)){
							$uams = $this->getTableLocator()->get('Uams');
							$uams = $uams->newEntities($uam_data);
							
							if ($this->Uams->saveMany($uams)) {
								$resp = 1;
								$msg = '<span class="text-success">User Access Matrix successfully created</span>';
							}else{
								$error = $this->showError($uam);
								$this->Log(json_encode($uam->getErrors()));
								$msg = '<span class="text-danger">'.$error.'</span>';
							} 
						}else{
							$msg = '<span class="text-danger">Proper settings is required</span>';
						}
					//}
					
				echo json_encode(array('resp' => $resp, 'msg' => $msg));
				die();
		}
		
		
		
        $groups = $this->Uams->Groups->find('list')
		->where(['id >' => 1])
		->order(['name' => 'ASC'])
		->contain([]);
		
        $this->set(compact('uam', 'groups'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Uam id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $uam = $this->Uams->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $uam = $this->Uams->patchEntity($uam, $this->request->getData());
            if ($this->Uams->save($uam)) {
                $this->Flash->success(__('The uam has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The uam could not be saved. Please, try again.'));
        }
        $groups = $this->Uams->Groups->find('list', ['limit' => 200])->all();
        $this->set(compact('uam', 'groups'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Uam id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $uam = $this->Uams->get($id);
        if ($this->Uams->delete($uam)) {
            $this->Flash->success(__('The uam has been deleted.'));
        } else {
            $this->Flash->error(__('The uam could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
