<?php
declare(strict_types=1);

namespace App\Controller\Admin;
use App\Controller\AppController;
use Cake\I18n\FrozenTime;

/**
 * Userlogins Controller
 *
 * @property \App\Model\Table\UserloginsTable $Userlogins
 * @method \App\Model\Entity\Userlogin[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class UserloginsController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		$this->Authorization->skipAuthorization();
	}
	
    public function index(){
       $users = $this->Userlogins->Users->find('list')->where(['id >' => 1]);
	   $this->set(compact('users'));
    }


    public function view(){
		$user = $this->getCurrentUser();
		$this->set(compact('user'));
	}
	
    public function indexajax($id = null, $from=null, $to=null){
	   if($this->request->is('ajax')){
			$this->ajaxLayout();
			$_data 	= array();
			
			$data 								= $this->request->getData();
			$draw 								= $data['draw'];
			$row 								= $data['start']; //page
			$rowperpage 				= ((isset($data['length']) && $data['length'] > 0) ? $data['length'] : -1);  //limit
			$columnIndex 				= $data['order'][0]['column']; //Column index
			$columnName 				= $data['columns'][$columnIndex]['data']; //Column name
			$columnSortOrder 		= $data['order'][0]['dir']; // asc or desc
			
			$orderby = ['Userlogins.login' => "DESC"];
			
			$this->log("From " .$from. " To " . $to);
			
			$from 	= empty($from) ? date('Y-m-d', strtotime("-29 days")) : date("Y-m-d", strtotime($from));
			$to 		= empty($to) ? date("Y-m-d") : date("Y-m-d", strtotime($to));

			$where[] = ['DATE(Userlogins.login) >=' => $from,  'DATE(Userlogins.login) <=' => $to];
			
			
			if(isset($id) && !empty($id)){
				$where[] = ['Userlogins.id >' => 0];
			}
			
			$q1 		= $this->Userlogins->find()
							->where($where)
							->contain([])
							->count();

			$totalRecords 	= $q1;
			$totalRecordwithFilter 	= $q1;
			
			
			if($rowperpage <=0){
				$sales = $this->Userlogins->find()
					->where($where)
					//->bind(':start', $from, 'date')
					//->bind(':end',  $to, 'date')
					//->contain(['Transactions', 'Users'])
					->order($orderby)
					->all();
			}else{	
				$sales = $this->Userlogins->find()
					->where($where)
					//->bind(':start', $from, 'date')
					//->bind(':end',  $to, 'date')
				//	->contain(['Transactions', 'Users'])
					->order($orderby)
					->limit($rowperpage)
					->offset($row)
					->all();
			}				
								
			$total_sales = 0;
			if(!empty($sales)):
				foreach($sales as $u):
				
					$login = new FrozenTime($u->login);
					
				   $_data[] = array( 
						'login'		=>  $login->i18nFormat('MM/dd/YYYY'),
						'logout'	=> 	$u->logout,
						'worktime'	=> 	$u->worktime,
						'late'		=> 	$u->worktime,
						'overtime'	=> 	$u->worktime,
						'rate'		=> 	$u->worktime,
						'ot_rate'	=> 	$u->worktime
						
					);
				endforeach;
			endif;	
				 
			## Response
			$response = array(
			  "draw" => intval($draw),
			  "iTotalRecords" => $totalRecords,
			  "iTotalDisplayRecords" => $totalRecordwithFilter,
			  "aaData" => $_data
			);

			echo json_encode($response);
			exit();
		}
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $userlogin = $this->Userlogins->newEmptyEntity();
        if ($this->request->is('post')) {
            $userlogin = $this->Userlogins->patchEntity($userlogin, $this->request->getData());
            if ($this->Userlogins->save($userlogin)) {
                $this->Flash->success(__('The userlogin has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The userlogin could not be saved. Please, try again.'));
        }
        $users = $this->Userlogins->Users->find('list', ['limit' => 200])->all();
        $this->set(compact('userlogin', 'users'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Userlogin id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $userlogin = $this->Userlogins->get($id, [
            'contain' => [],
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $userlogin = $this->Userlogins->patchEntity($userlogin, $this->request->getData());
            if ($this->Userlogins->save($userlogin)) {
                $this->Flash->success(__('The userlogin has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The userlogin could not be saved. Please, try again.'));
        }
        $users = $this->Userlogins->Users->find('list', ['limit' => 200])->all();
        $this->set(compact('userlogin', 'users'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Userlogin id.
     * @return \Cake\Http\Response|null|void Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $userlogin = $this->Userlogins->get($id);
        if ($this->Userlogins->delete($userlogin)) {
            $this->Flash->success(__('The userlogin has been deleted.'));
        } else {
            $this->Flash->error(__('The userlogin could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
