<?php

namespace App\Controller\Component;

use Cake\Controller\Component;

class CommonComponent extends Component
{

	public function imageDIR($type = null)
	{
		switch ($type) {
			case "display":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']) . '/product_images/';
				break;
			case "web":
				$dir = "http://localhost/DEPED/product_images/";
				break;
			case "received":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']) . '/DEPED/product_images/Received';
				break;
			case "inspection":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']) . '/DEPED/product_images/Inspection';
				break;
			case "acceptance":
				$dir = dirname($_SERVER['DOCUMENT_ROOT']) . '/DEPED/product_images/Acceptance';
				break;
			default:
				$dir = dirname($_SERVER['DOCUMENT_ROOT']) . '/DEPED/product_images/Uploads';
				break;
		}
		return $dir;
	}

	public function imagePublicUrl()
	{
		return 'http://localhost/JAMC_MARKETING/product_images/';
	}


	public function generateString($len = null)
	{
		$str = "";
		$len = !empty($len) ? $len : 6;
		$characters = array_merge(range('A', 'Z'), range('a', 'z'), range('0', '9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $len; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}

		return strtoupper($str);
	}

	
	public function generateOTP()
	{
		$str = "";
		$characters = array_merge(range('0', '9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < 6; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}

		return strtoupper($str);
	}

	public function formatSeries($no)
	{
		return str_pad($no, 8, "0", STR_PAD_LEFT);
	}

	public function splitName($name)
	{
		$name = trim($name);
		$last_name = (strpos($name, ' ') === false) ? '' : preg_replace('#.*\s([\w-]*)$#', '$1', $name);
		$first_name = trim(preg_replace('#' . preg_quote($last_name, '#') . '#', '', $name));
		return array($first_name, $last_name);
	}

	public function validateDate($date)
	{

		$date = str_replace("/", "", $date);
		$mo = substr($date, 0, 2);
		$dy = substr($date, 2, 2);
		$yr = substr($date, 4, 4);

		if ($mo <= 12) {
			if ($dy <= 31) {
				if ($yr <= date("Y")) {
					return true;
				} else {
					return false;
				}
			} else {
				return false;
			}
		} else {
			return false;
		}
	}

	public function civilStatus()
	{
		$options = [
			1 	=> 'SINGLE',
			2 	=> 'MARRIED',
			3 	=> 'WIDOWED',
			4	=> 'SEPARATED',
			5	=> 'OTHERS',
		];

		return $options;
	}

	public function payMent()
	{
		$options = [

			2 			=> 'DIRECT',
			3 			=> 'LOCAL (H.SCHOOL/COLLEGE/UNIVERSITY)',
			4 			=> 'EXEMPTED',
			5 			=> 'IBM REGIONAL',
			7 			=> 'EMPLOYEE'

			// Unused
			// 'RPSU' 		=> 'REGIONAL PAYROLL SYSTEM UNIT',
			// 'IBM NATIONAL' 	=> 'IBM NATIONAL',
		];

		return $options;
	}

	public function payMentMode()
	{
		$options = [
			1 		=> 'MONTHLY',
			2 		=> 'QUARTERLY',
			3		=> 'SEMI-ANNUAL',
			4 		=> 'ANNUAL',
		];

		return $options;
	}

	public function docuMents($sel = null)
	{
		$options = [
			1	=> 'Permanent Appointment or Latest Service Record',
			2	=> 'Latest Payslip',
			3	=> 'Photo Copy or 2 Valid ID',
			4	=> 'Personal Health Declaration',
			5	=> 'Verifiers Approval (DepEd Approval)',
			6	=> 'Authority to deduct (APDS)',
			7	=> 'Selfie Photo Holding digitally signed accomplished application (for online registation only)',
			8	=> 'Recent ID Picture'
		];

		if (isset($sel) && !empty($sel)) {
			$options = $options[$sel];
		}

		return $options;
	}

	public function claimsRequirements($sel = null)
	{
		$options = [
			'1' => 'Photocopy of two valid IDs reflecting clear signature',
			'2' => 'Original Birth Certificate issued by PSA',
			'3' => 'Original Medical certificate OR Medical abstract',
			'4' => 'Original or Certified True Copy of Hospitalization Billing',
			'5' => 'Original MAS certificate, in case of loss, originally signed affidavit of loss',
			'6' => 'Photocopy of latest payslip WITHOUT PPSTA deductions',
			'7' => 'Original endorsement of withdrawal application for PPSTA-MAS membership by the Membership Exit Counselling Committee',
			'8' => 'Photocopy of GSIS Retirement Voucher or Updated Service Record with Retirement Date (If the member resigned from the service, proof of resignation must be submitted)'
		];

		if (isset($sel) && !empty($sel)) {
			$options = $options[$sel];
		}

		return $options;
	}
	
	public function uamList(){
		$controllersArray = [
			'accountingdefs' => 'Accountingdefs',
			'accountings' => 'Accountings',
			'accsubdistributions' => 'Accsubdistributions',
			'acctransactions' => 'Acctransactions',
			'acctranstypes' => 'Acctranstypes',
			'accvouchers' => 'Accvouchers',
			'articles' => 'Articles',
			'banks' => 'Banks',
			'barangays' => 'Barangays',
			'benefits' => 'Benefits',
			'candidates' => 'Candidates',
			'categories' => 'Categories',
			'cities' => 'Cities',
			'claimcategories' => 'Claimcategories',
			'claims' => 'Claims',
			'claimtypes' => 'Claimtypes',
			'customers' => 'Customers',
			'departments' => 'Departments',
			'divisions' => 'Divisions',
			'documents' => 'Documents',
			'elections' => 'Elections',
			'errors' => 'Errors',
			'groups' => 'Groups',
			'loans' => 'Loans',
			'loansrates' => 'Loansrates',
			'loanstypes' => 'Loanstypes',
			'membersassessments' => 'Membersassessments',
			'members' => 'Members',
			'membersplans' => 'Membersplans',
			'membersplantypes' => 'Membersplantypes',
			'membersspecials' => 'Membersspecials',
			'membersspecialscontrollers' => 'Membersspecialscontrollers',
			'officerpositions' => 'Officerpositions',
			'pages' => 'Pages',
			'premiums' => 'Premiums',
			'products' => 'Products',
			'provinces' => 'Provinces',
			'refunds' => 'Refunds',
			'roles' => 'Roles',
			'sales' => 'Sales',
			'schools' => 'Schools',
			'settings' => 'Settings',
			'stations' => 'Stations',
			'stocks' => 'Stocks',
			'transactions' => 'Transactions',
			'uams' => 'Uams',
			'usercastings' => 'Usercastings',
			'userlogins' => 'Userlogins',
			'users' => 'Users',
			'utilities' => 'Utilities',
			'votecastings' => 'Votecastings',
			'votecounts' => 'Votecounts',
		];
		
		return $controllersArray;

	}
	
	public static function maskContactNumber($contactNumber) {
        $masked = substr($contactNumber, 0, 2) . str_repeat('*', strlen($contactNumber) - 5) . substr($contactNumber, -3);
        return $masked;
    }
	
}
