<?php
declare(strict_types=1);

namespace App\Controller;
use Cake\Routing\Router;


class UsersController extends AppController
{
   
	public function beforeFilter(\Cake\Event\EventInterface $event){
		parent::beforeFilter($event);
		
		$this->Authentication->allowUnauthenticated(['login', 
		'updateAdmin', 'createadmin',  'loginwithqrcode', 
		'unauthorized', 
		]);
	}

	
/* 	public function updateAdmin(){
		  $user = $this->Users->get(1, [
            'contain' => [],
        ]);
	

					$this->ajaxLayout();
					$resp = 0;
					
					$user = $this->Users->patchEntity($user,  ['validation' => false]);
					
		$user->password = "admin";
		if($this->Users->save($user)){
			echo "saved";
		}else{
			echo "failed";
		}
		
		exit();
		
	} */
	
	

	public function validateotpadmin(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$user	= $this->getCurrentUser();
		$id 	= $user['id'];
		
		if ($this->request->is('post')) {
			$data = $this->request->getData();
			$otp  = $data['otp'];
			$user = $this->Users->find()
			->select(['id', 'otp_status'])
			->where(['id' => $id, 'otp' => $otp])
			->first();
			
			if(!empty($user)){
				$user->otp_status = 1;
				if($this->Users->save($user)){
					$this->updateLogin("login", $user->id);
					$target = $this->Authentication->getLoginRedirect() ?? '/admin/settings/system-statistics';
					return $this->redirect($target);
				}
				
			}
			
			//lock the user in many attempts
			$this->Flash->error('You have provided an invalid OTP. Please try again');
		}
		
	}
	
	public function unauthorized(){
		
	}
	
	private function updateLogin($type = null, $userid=null){
		
		if(isset($userid) && !empty($userid)){
			$user = $this->Users->get($userid);
			
			if($type=="login"){			
				$user->last_login = date('Y-m-d H:i:s');
				$user->login_status = "ONLINE";
				$user->ip_address = $_SERVER['REMOTE_ADDR'];
			}else{
				$user->last_logout = date('Y-m-d H:i:s');
				$user->login_status = "OFFLINE";
				//$user->otp = $this->Common->generateOTP();
				$user->otp_status = 0;
			}
			
			$this->Users->save($user);
		}
	}
	
	private function generateNewOTP($userid){
		$user = $this->Users->get($userid);
		$user->otp = "118899"; //$this->Common->generateOTP();
		$user->otp_generated = date("Y-m-d H:i:s");
		$user->otp_status = 0;
		$this->Users->save($user);		
	}
	
	private function setTheKey(){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < 6; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		
        $refid = microtime(true) . $str;
		return $refid;
	}
	
	private function generatetimelog($id=null, $rate=null, $key=null){
		
		$session = $this->getRequest()->getSession(); 
		
		$session->write([
			'Config.theme' => 'blue',
			'Config.language' => 'en',
			'Config.session_key' => $key
		]);
		
		$userlogin = $this->Users->Userlogins->newEmptyEntity();      
        $userlogin = $this->Users->Userlogins->patchEntity($userlogin, ['validation' => false]);
		$userlogin->user_id = $id;
		$userlogin->login = date("Y-m-d H:i:s");
		$userlogin->skey = $key;
		$userlogin->rate = $rate;
        $this->Users->Userlogins->save($userlogin);
		
	}
	
	private function computeTimeLog(){
		
	}
	
	
	public function validateotp(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$uuser	= $this->getCurrentUser();
		$id 	= $uuser['id'];
		
		$_user = $this->Users->newEmptyEntity();
		$this->set('_user', $_user);
		$this->set('user', $uuser);
		
		$status = 0;
		$role = $uuser['role_id'];
		$target = 0;
		$msg = "OTP Validation failed. Please try again.";
		
		$session = $this->request->getSession();
		$contactNumber = $session->read('User.contact');
		if ($contactNumber) {
			$maskedContactNumber = $this->Common->maskContactNumber($contactNumber);
			$this->set(compact('maskedContactNumber'));
		}
		

		if($this->request->is('ajax')){
			$this->ajaxLayout();
				
			//$data = $this->request->input('json_decode', true);
			$data = json_decode((string)$this->request->getBody(), true);
			
			if (json_last_error() !== JSON_ERROR_NONE) {
				log('JSON decoding error: ' . json_last_error_msg());
				// Handle the error appropriately
			}

			$otp = $data['otp'] ?? null;
				
			$user = $this->Users->find()
			->select(['id', 'otp_status'])
			//->where(['id' => $id, 'otp' => $otp]) //temporary disabled
			->where(['id' => $id])
			->first();
			
			//$this->log("OTP " . $otp);
			
			if(!empty($user)){
				$key = $this->setTheKey();
				$user->otp_status = 1;
				$user->skey = $key;
				
				if($this->Users->save($user)){					
					$this->updateLogin("login", $user->id);
					$this->generatetimelog($user->id, $user->rate, $key);
					$status = 1;
					$_link = Router::url([
						'prefix' => 'Admin', 
						'controller' => 'users', 
						'action' => 'dashboard'
					]);
					
					$target = $_link; //$this->Authentication->getLoginRedirect() ?? '/admin/settings/system-statistics';
					$msg = "OTP Validation Success";
				}
			}else{
				$msg = "You have provided an invalid OTP";
			}
			
			$resp = [
				'target' => $target,
				'role' => $role,
				'status' => $status,
				'message' => $msg
			];
					
			$this->response = $this->response->withType('application/json')
            ->withStringBody(json_encode($resp));
			
			return $this->response;


		}
			
		
		
	}
	
	
	public function login(){
		$this->viewBuilder()->setLayout('login');
		$this->Authorization->skipAuthorization();
		$user = $this->Users->newEmptyEntity();
		$this->set('user', $user);
			
		
		if($this->request->is('post')){
			$result = $this->Authentication->getResult();
			$status = 0;
			$role = 0;
			$target = 0;
			
			if ($result->isValid()) {
				$user = $result->getData();
				if($user->status=="ACTIVE"){
					$this->updateLogin("logout", $user->id);
					
					$this->generateNewOTP($user->id);
					$role = $user->role_id;
					$status = 1;
					$msg = "Account successfully authenticated, please click Proceed to continue";
					
					$userContactNumber = $user->contact_no; // This should be retrieved from your user data
					$this->request->getSession()->write('User.contact', $userContactNumber);

					$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
					
				}else{
					$msg = "Your account needs to be activated. Please check your email for the activation link";
				}
			}else{
				$msg ="Login failed. You have provided an invalid credentials.";
			}
			
			if($this->request->is('ajax')){
				$resp = [
					'target' => $target,
					'role' => $role,
					'status' => $status,
					'message' => $msg
				];
				
				echo json_encode($resp);
				exit();
			}else{
				return $this->redirect($target);
			}
		} 
	}
	
	
	public function loginwithqrcode($user_data = null) {
		if (!empty($user_data)) {
			$user_data = json_decode(base64_decode($user_data));

			$refid = $user_data->refid ?? "";
			$username = $user_data->code ?? "";
			$id = $user_data->id ?? "";
			
			$this->log("find user " . $refid . " ".$username);
			
			if (!empty($refid) && !empty($username)) {
				$this->Authorization->skipAuthorization();
				$user = $this->Users->find()
					->where(['refid' => $refid, 'username' => $username])
					->contain([])
					->first();

				if ($user && $user->status == "ACTIVE") {
					$this->Authentication->setIdentity($user);
					// $user is already the authenticated user's data
					$this->updateLogin("logout", $user->id);
					$this->generateNewOTP($user->id);
					$this->request->getSession()->write('User.contact', '09556254487');

					$target = $this->Authentication->getLoginRedirect() ?? '/users/validateotp';
					return $this->redirect($target); 
				} else {
					// Handle scenarios where user is not found or not active
					// Possibly set a flash message or log the event
					$this->log("User is inactive " . $refid . " ".$username);
				}
			} 
		}

		$this->ajaxLayout();
		// Consider adding a response for when user_data is empty or authentication fails
	}


	
	
	public function logout(){
		//$this->Authorization->skipAuthorization();
		//$this->updateLogin("logout");
		$result = $this->Authentication->getResult();
		$user = $result->getData();
		$this->updateLogin("logout", $user->id);
		
		$this->Authentication->logout();
		return $this->redirect(['controller' => 'Users', 'action' => 'login']);
	}

   
}
