<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Transactionmaster Entity
 *
 * @property int $id
 * @property int|null $TransactionNumber
 * @property string|null $TransactionCode
 * @property string|null $TransactionDate
 * @property string|null $Particulars
 * @property string|null $Name
 * @property string|null $LoanMasterId
 * @property string|null $Amount
 * @property string|null $EntryDate
 * @property string|null $UpdateDateTime
 */
class Transactionmaster extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected $_accessible = [
        'TransactionNumber' => true,
        'TransactionCode' => true,
        'TransactionDate' => true,
        'Particulars' => true,
        'Name' => true,
        'LoanMasterId' => true,
        'Amount' => true,
        'EntryDate' => true,
        'UpdateDateTime' => true,
        'loanmaster' => true,
    ];
	
	
	public function __construct() {
        $this->_accessible = array_change_key_case($this->_accessible, CASE_LOWER);
    }

}


