<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Chartofaccounts Model
 *
 * @method \App\Model\Entity\Chartofaccount newEmptyEntity()
 * @method \App\Model\Entity\Chartofaccount newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Chartofaccount[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Chartofaccount get($primaryKey, $options = [])
 * @method \App\Model\Entity\Chartofaccount findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Chartofaccount patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Chartofaccount[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Chartofaccount|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chartofaccount saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Chartofaccount[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Chartofaccount[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Chartofaccount[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Chartofaccount[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class ChartofaccountsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('chartofaccounts');
        $this->setDisplayField('AccountCode');
        $this->setPrimaryKey('id');

		$this->hasMany('Transactiondetails', [
            'foreignKey' => 'AccountCode',
        ]);
		
		
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('AccountCode')
            ->maxLength('AccountCode', 5)
            ->allowEmptyString('AccountCode');

        $validator
            ->scalar('AccountTitle')
            ->maxLength('AccountTitle', 48)
            ->allowEmptyString('AccountTitle');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        $validator
            ->scalar('UpdateDateTime')
            ->maxLength('UpdateDateTime', 19)
            ->allowEmptyString('UpdateDateTime');

        return $validator;
    }
	
	
	public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(
			['AccountCode'],
			'Account Code already exists. Please check the details again.'
		), 
			['errorField' => 'AccountCode']
		);
        //$rules->add($rules->isUnique(['email']), ['errorField' => 'email']);

        return $rules;
    }
	
}
