<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Monthlydeductions Model
 *
 * @property \App\Model\Table\MembersTable&\Cake\ORM\Association\BelongsTo $Members
 *
 * @method \App\Model\Entity\Monthlydeduction newEmptyEntity()
 * @method \App\Model\Entity\Monthlydeduction newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Monthlydeduction[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Monthlydeduction get($primaryKey, $options = [])
 * @method \App\Model\Entity\Monthlydeduction findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Monthlydeduction patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Monthlydeduction[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Monthlydeduction|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Monthlydeduction saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Monthlydeduction[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Monthlydeduction[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Monthlydeduction[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Monthlydeduction[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class MonthlydeductionsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('monthlydeductions');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Members', [
            'foreignKey' => 'memberid',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
       /*  $validator
            ->integer('member_id')
            ->notEmptyString('member_id');

        $validator
            ->decimal('ArrearsAmount')
            ->allowEmptyString('ArrearsAmount');

        $validator
            ->decimal('InterestArrears')
            ->allowEmptyString('InterestArrears');

        $validator
            ->decimal('DeductionAmount')
            ->allowEmptyString('DeductionAmount');

        $validator
            ->decimal('RiceAmount')
            ->allowEmptyString('RiceAmount');

        $validator
            ->scalar('DatePaid')
            ->maxLength('DatePaid', 19)
            ->allowEmptyString('DatePaid');

        $validator
            ->scalar('Remarks')
            ->maxLength('Remarks', 36)
            ->allowEmptyString('Remarks');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        $validator
            ->scalar('UpdateDateTime')
            ->maxLength('UpdateDateTime', 19)
            ->allowEmptyString('UpdateDateTime');
 */
        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn('memberid', 'Members'), ['errorField' => 'member_id']);

        return $rules;
    }
}
