<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Transactiondetails Model
 *
 * @method \App\Model\Entity\Transactiondetail newEmptyEntity()
 * @method \App\Model\Entity\Transactiondetail newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Transactiondetail[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Transactiondetail get($primaryKey, $options = [])
 * @method \App\Model\Entity\Transactiondetail findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Transactiondetail patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Transactiondetail[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Transactiondetail|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Transactiondetail saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Transactiondetail[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactiondetail[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactiondetail[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactiondetail[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class TransactiondetailsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('transactiondetails');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
		
		$this->belongsTo('Chartofaccounts', [
            'foreignKey' => 'AccountCode',
            'joinType' => 'INNER',
        ]);

    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->allowEmptyString('TransactionNumber');

        $validator
            ->scalar('TransactionCode')
            ->maxLength('TransactionCode', 2)
            ->allowEmptyString('TransactionCode');

        $validator
            ->scalar('TransactionDate')
            ->maxLength('TransactionDate', 19)
            ->allowEmptyString('TransactionDate');

        $validator
            ->scalar('AccountCode')
            ->maxLength('AccountCode', 5)
            ->allowEmptyString('AccountCode');

        $validator
            ->decimal('Debit')
            ->allowEmptyString('Debit');

        $validator
            ->decimal('Credit')
            ->allowEmptyString('Credit');

        $validator
            ->allowEmptyString('Sequence');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        return $validator;
    }
}
