<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Transactionmasters Model
 *
 * @method \App\Model\Entity\Transactionmaster newEmptyEntity()
 * @method \App\Model\Entity\Transactionmaster newEntity(array $data, array $options = [])
 * @method \App\Model\Entity\Transactionmaster[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Transactionmaster get($primaryKey, $options = [])
 * @method \App\Model\Entity\Transactionmaster findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \App\Model\Entity\Transactionmaster patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Transactionmaster[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Transactionmaster|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Transactionmaster saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Transactionmaster[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactionmaster[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactionmaster[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \App\Model\Entity\Transactionmaster[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 */
class TransactionmastersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('transactionmasters');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
		
		$this->belongsTo('Loanmasters', [
            'foreignKey' => 'loanmasterid',
            'joinType' => 'INNER',
        ]);
		
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->allowEmptyString('TransactionNumber');

        $validator
            ->scalar('TransactionCode')
            ->maxLength('TransactionCode', 2)
            ->allowEmptyString('TransactionCode');

        $validator
            ->scalar('TransactionDate')
            ->maxLength('TransactionDate', 19)
            ->allowEmptyString('TransactionDate');

        $validator
            ->scalar('Particulars')
            ->maxLength('Particulars', 200)
            ->allowEmptyString('Particulars');

        $validator
            ->scalar('Name')
            ->maxLength('Name', 52)
            ->allowEmptyString('Name');

        $validator
            ->scalar('LoanMasterId')
            ->maxLength('LoanMasterId', 5)
            ->allowEmptyString('LoanMasterId');

        $validator
            ->decimal('Amount')
            ->allowEmptyString('Amount');

        $validator
            ->scalar('EntryDate')
            ->maxLength('EntryDate', 19)
            ->allowEmptyString('EntryDate');

        $validator
            ->scalar('UpdateDateTime')
            ->maxLength('UpdateDateTime', 19)
            ->allowEmptyString('UpdateDateTime');

        return $validator;
    }
	
	
	public function getNextTransactionNumber(): ?int
    {
        $lastTransaction = $this->find()
            ->select(['TransactionNumber'])
            ->where(['TransactionCode' => 'CV'])
            ->order(['TransactionNumber' => 'DESC'])
            ->first();

        if ($lastTransaction && is_numeric($lastTransaction->TransactionNumber)) {
            return (int)$lastTransaction->TransactionNumber + 1;
        }

        return null; // Or return 1 if you want to start from 1 when no records are found
    }
}
