<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Blockedcard> $blockedcards
 */
?>
<div class="blockedcards index content">
    <?= $this->Html->link(__('New Blockedcard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Blockedcards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('customer_id') ?></th>
                    <th><?= $this->Paginator->sort('account_id') ?></th>
                    <th><?= $this->Paginator->sort('user_id') ?></th>
                    <th><?= $this->Paginator->sort('generatedcard_id') ?></th>
                    <th><?= $this->Paginator->sort('card_number') ?></th>
                    <th><?= $this->Paginator->sort('date_blocked') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($blockedcards as $blockedcard): ?>
                <tr>
                    <td><?= $this->Number->format($blockedcard->id) ?></td>
                    <td><?= $blockedcard->has('customer') ? $this->Html->link($blockedcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $blockedcard->customer->id]) : '' ?></td>
                    <td><?= $blockedcard->has('account') ? $this->Html->link($blockedcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $blockedcard->account->id]) : '' ?></td>
                    <td><?= $blockedcard->has('user') ? $this->Html->link($blockedcard->user->name, ['controller' => 'Users', 'action' => 'view', $blockedcard->user->id]) : '' ?></td>
                    <td><?= $blockedcard->has('generatedcard') ? $this->Html->link($blockedcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $blockedcard->generatedcard->id]) : '' ?></td>
                    <td><?= h($blockedcard->card_number) ?></td>
                    <td><?= h($blockedcard->date_blocked) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $blockedcard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $blockedcard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $blockedcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $blockedcard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
