<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Branch $branch
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Branch'), ['action' => 'edit', $branch->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Branch'), ['action' => 'delete', $branch->id], ['confirm' => __('Are you sure you want to delete # {0}?', $branch->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Branches'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Branch'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="branches view content">
            <h3><?= h($branch->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($branch->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Telephone') ?></th>
                    <td><?= h($branch->telephone) ?></td>
                </tr>
                <tr>
                    <th><?= __('Email') ?></th>
                    <td><?= h($branch->email) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($branch->id) ?></td>
                </tr>
            </table>
            <div class="text">
                <strong><?= __('Address') ?></strong>
                <blockquote>
                    <?= $this->Text->autoParagraph(h($branch->address)); ?>
                </blockquote>
            </div>
            <div class="related">
                <h4><?= __('Related Accounts') ?></h4>
                <?php if (!empty($branch->accounts)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Customer Id') ?></th>
                            <th><?= __('Branch Id') ?></th>
                            <th><?= __('Account Type') ?></th>
                            <th><?= __('Balance') ?></th>
                            <th><?= __('Account No') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($branch->accounts as $accounts) : ?>
                        <tr>
                            <td><?= h($accounts->id) ?></td>
                            <td><?= h($accounts->customer_id) ?></td>
                            <td><?= h($accounts->branch_id) ?></td>
                            <td><?= h($accounts->account_type) ?></td>
                            <td><?= h($accounts->balance) ?></td>
                            <td><?= h($accounts->account_no) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Accounts', 'action' => 'view', $accounts->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Accounts', 'action' => 'edit', $accounts->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Accounts', 'action' => 'delete', $accounts->id], ['confirm' => __('Are you sure you want to delete # {0}?', $accounts->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
            <div class="related">
                <h4><?= __('Related Requestcards') ?></h4>
                <?php if (!empty($branch->requestcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Institution Id') ?></th>
                            <th><?= __('Product Id') ?></th>
                            <th><?= __('Branch Id') ?></th>
                            <th><?= __('User Id') ?></th>
                            <th><?= __('Requested Date') ?></th>
                            <th><?= __('Total Cards') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Card Type') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($branch->requestcards as $requestcards) : ?>
                        <tr>
                            <td><?= h($requestcards->id) ?></td>
                            <td><?= h($requestcards->institution_id) ?></td>
                            <td><?= h($requestcards->product_id) ?></td>
                            <td><?= h($requestcards->branch_id) ?></td>
                            <td><?= h($requestcards->user_id) ?></td>
                            <td><?= h($requestcards->requested_date) ?></td>
                            <td><?= h($requestcards->total_cards) ?></td>
                            <td><?= h($requestcards->status) ?></td>
                            <td><?= h($requestcards->card_type) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Requestcards', 'action' => 'view', $requestcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Requestcards', 'action' => 'edit', $requestcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Requestcards', 'action' => 'delete', $requestcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $requestcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
