<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Cardbatch> $cardbatches
 */
?>
<div class="cardbatches index content">
    <?= $this->Html->link(__('New Cardbatch'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Cardbatches') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('requestcard_id') ?></th>
                    <th><?= $this->Paginator->sort('batch_number') ?></th>
                    <th><?= $this->Paginator->sort('generation_date') ?></th>
                    <th><?= $this->Paginator->sort('total_cards') ?></th>
                    <th><?= $this->Paginator->sort('status') ?></th>
                    <th><?= $this->Paginator->sort('available_count') ?></th>
                    <th><?= $this->Paginator->sort('delivered') ?></th>
                    <th><?= $this->Paginator->sort('assigned') ?></th>
                    <th><?= $this->Paginator->sort('returned') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($cardbatches as $cardbatch): ?>
                <tr>
                    <td><?= $this->Number->format($cardbatch->id) ?></td>
                    <td><?= $cardbatch->has('requestcard') ? $this->Html->link($cardbatch->requestcard->id, ['controller' => 'Requestcards', 'action' => 'view', $cardbatch->requestcard->id]) : '' ?></td>
                    <td><?= $this->Number->format($cardbatch->batch_number) ?></td>
                    <td><?= h($cardbatch->generation_date) ?></td>
                    <td><?= $this->Number->format($cardbatch->total_cards) ?></td>
                    <td><?= h($cardbatch->status) ?></td>
                    <td><?= $cardbatch->available_count === null ? '' : $this->Number->format($cardbatch->available_count) ?></td>
                    <td><?= $cardbatch->delivered === null ? '' : $this->Number->format($cardbatch->delivered) ?></td>
                    <td><?= $cardbatch->assigned === null ? '' : $this->Number->format($cardbatch->assigned) ?></td>
                    <td><?= $cardbatch->returned === null ? '' : $this->Number->format($cardbatch->returned) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $cardbatch->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $cardbatch->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $cardbatch->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cardbatch->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
