<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Cardbatch $cardbatch
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Cardbatch'), ['action' => 'edit', $cardbatch->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Cardbatch'), ['action' => 'delete', $cardbatch->id], ['confirm' => __('Are you sure you want to delete # {0}?', $cardbatch->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Cardbatches'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Cardbatch'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="cardbatches view content">
            <h3><?= h($cardbatch->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Requestcard') ?></th>
                    <td><?= $cardbatch->has('requestcard') ? $this->Html->link($cardbatch->requestcard->id, ['controller' => 'Requestcards', 'action' => 'view', $cardbatch->requestcard->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Status') ?></th>
                    <td><?= h($cardbatch->status) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($cardbatch->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Batch Number') ?></th>
                    <td><?= $this->Number->format($cardbatch->batch_number) ?></td>
                </tr>
                <tr>
                    <th><?= __('Total Cards') ?></th>
                    <td><?= $this->Number->format($cardbatch->total_cards) ?></td>
                </tr>
                <tr>
                    <th><?= __('Available Count') ?></th>
                    <td><?= $cardbatch->available_count === null ? '' : $this->Number->format($cardbatch->available_count) ?></td>
                </tr>
                <tr>
                    <th><?= __('Delivered') ?></th>
                    <td><?= $cardbatch->delivered === null ? '' : $this->Number->format($cardbatch->delivered) ?></td>
                </tr>
                <tr>
                    <th><?= __('Assigned') ?></th>
                    <td><?= $cardbatch->assigned === null ? '' : $this->Number->format($cardbatch->assigned) ?></td>
                </tr>
                <tr>
                    <th><?= __('Returned') ?></th>
                    <td><?= $cardbatch->returned === null ? '' : $this->Number->format($cardbatch->returned) ?></td>
                </tr>
                <tr>
                    <th><?= __('Generation Date') ?></th>
                    <td><?= h($cardbatch->generation_date) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Generatedcards') ?></h4>
                <?php if (!empty($cardbatch->generatedcards)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Cardbatch Id') ?></th>
                            <th><?= __('Card Number') ?></th>
                            <th><?= __('Status') ?></th>
                            <th><?= __('Creation Date') ?></th>
                            <th><?= __('Card Type') ?></th>
                            <th><?= __('Date In Transit') ?></th>
                            <th><?= __('Date Delivered') ?></th>
                            <th><?= __('Date Assigned') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($cardbatch->generatedcards as $generatedcards) : ?>
                        <tr>
                            <td><?= h($generatedcards->id) ?></td>
                            <td><?= h($generatedcards->cardbatch_id) ?></td>
                            <td><?= h($generatedcards->card_number) ?></td>
                            <td><?= h($generatedcards->status) ?></td>
                            <td><?= h($generatedcards->creation_date) ?></td>
                            <td><?= h($generatedcards->card_type) ?></td>
                            <td><?= h($generatedcards->date_in_transit) ?></td>
                            <td><?= h($generatedcards->date_delivered) ?></td>
                            <td><?= h($generatedcards->date_assigned) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Generatedcards', 'action' => 'view', $generatedcards->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Generatedcards', 'action' => 'edit', $generatedcards->id]) ?>
                                <?= $this->Form->postLink(__('Delete'), ['controller' => 'Generatedcards', 'action' => 'delete', $generatedcards->id], ['confirm' => __('Are you sure you want to delete # {0}?', $generatedcards->id)]) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
