<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Expiredcard $expiredcard
 * @var string[]|\Cake\Collection\CollectionInterface $customers
 * @var string[]|\Cake\Collection\CollectionInterface $accounts
 * @var string[]|\Cake\Collection\CollectionInterface $users
 * @var string[]|\Cake\Collection\CollectionInterface $generatedcards
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $expiredcard->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $expiredcard->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Expiredcards'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column-responsive column-80">
        <div class="expiredcards form content">
            <?= $this->Form->create($expiredcard) ?>
            <fieldset>
                <legend><?= __('Edit Expiredcard') ?></legend>
                <?php
                    echo $this->Form->control('customer_id', ['options' => $customers]);
                    echo $this->Form->control('account_id', ['options' => $accounts]);
                    echo $this->Form->control('user_id', ['options' => $users]);
                    echo $this->Form->control('generatedcard_id', ['options' => $generatedcards]);
                    echo $this->Form->control('card_number');
                    echo $this->Form->control('date_expired');
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
