<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Expiredcard> $expiredcards
 */
?>
<div class="expiredcards index content">
    <?= $this->Html->link(__('New Expiredcard'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Expiredcards') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('customer_id') ?></th>
                    <th><?= $this->Paginator->sort('account_id') ?></th>
                    <th><?= $this->Paginator->sort('user_id') ?></th>
                    <th><?= $this->Paginator->sort('generatedcard_id') ?></th>
                    <th><?= $this->Paginator->sort('card_number') ?></th>
                    <th><?= $this->Paginator->sort('date_expired') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($expiredcards as $expiredcard): ?>
                <tr>
                    <td><?= $this->Number->format($expiredcard->id) ?></td>
                    <td><?= $expiredcard->has('customer') ? $this->Html->link($expiredcard->customer->id, ['controller' => 'Customers', 'action' => 'view', $expiredcard->customer->id]) : '' ?></td>
                    <td><?= $expiredcard->has('account') ? $this->Html->link($expiredcard->account->id, ['controller' => 'Accounts', 'action' => 'view', $expiredcard->account->id]) : '' ?></td>
                    <td><?= $expiredcard->has('user') ? $this->Html->link($expiredcard->user->name, ['controller' => 'Users', 'action' => 'view', $expiredcard->user->id]) : '' ?></td>
                    <td><?= $expiredcard->has('generatedcard') ? $this->Html->link($expiredcard->generatedcard->id, ['controller' => 'Generatedcards', 'action' => 'view', $expiredcard->generatedcard->id]) : '' ?></td>
                    <td><?= h($expiredcard->card_number) ?></td>
                    <td><?= h($expiredcard->date_expired) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $expiredcard->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $expiredcard->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $expiredcard->id], ['confirm' => __('Are you sure you want to delete # {0}?', $expiredcard->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
